/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PlaidErrorType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Errors are identified by `error_code` and categorized by `error_type`. Use these in preference to HTTP status codes to identify and handle specific errors. HTTP status codes are set and provide the broadest categorization of errors: 4xx codes are for developer- or user-related errors, and 5xx codes are for Plaid-related errors, and the status will be 2xx in non-error cases. An Item with a non-`null` error object will only be part of an API response when calling `/item/get` to view Item status. Otherwise, error fields will be `null` if no error has occurred; if an error has occurred, an error code will be returned instead.")
public class PlaidError {
    public static final String SERIALIZED_NAME_ERROR_TYPE = "error_type";
    @SerializedName(value="error_type")
    private PlaidErrorType errorType;
    public static final String SERIALIZED_NAME_ERROR_CODE = "error_code";
    @SerializedName(value="error_code")
    private String errorCode;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "error_message";
    @SerializedName(value="error_message")
    private String errorMessage;
    public static final String SERIALIZED_NAME_DISPLAY_MESSAGE = "display_message";
    @SerializedName(value="display_message")
    private String displayMessage;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_CAUSES = "causes";
    @SerializedName(value="causes")
    private List<Object> causes = null;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private Integer status;
    public static final String SERIALIZED_NAME_DOCUMENTATION_URL = "documentation_url";
    @SerializedName(value="documentation_url")
    private String documentationUrl;
    public static final String SERIALIZED_NAME_SUGGESTED_ACTION = "suggested_action";
    @SerializedName(value="suggested_action")
    private String suggestedAction;

    public PlaidError errorType(PlaidErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PlaidErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(PlaidErrorType errorType) {
        this.errorType = errorType;
    }

    public PlaidError errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The particular error code. Safe for programmatic use.")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public PlaidError errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(required=true, value="A developer-friendly representation of the error code. This may change over time and is not safe for programmatic use.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public PlaidError displayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A user-friendly representation of the error code. `null` if the error is not related to user action.  This may change over time and is not safe for programmatic use.")
    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public void setDisplayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
    }

    public PlaidError requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique ID identifying the request, to be used for troubleshooting purposes. This field will be omitted in errors provided by webhooks.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public PlaidError causes(List<Object> causes) {
        this.causes = causes;
        return this;
    }

    public PlaidError addCausesItem(Object causesItem) {
        if (this.causes == null) {
            this.causes = new ArrayList<Object>();
        }
        this.causes.add(causesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="In the Assets product, a request can pertain to more than one Item. If an error is returned for such a request, `causes` will return an array of errors containing a breakdown of these errors on the individual Item level, if any can be identified.  `causes` will only be provided for the `error_type` `ASSET_REPORT_ERROR`. `causes` will also not be populated inside an error nested within a `warning` object.")
    public List<Object> getCauses() {
        return this.causes;
    }

    public void setCauses(List<Object> causes) {
        this.causes = causes;
    }

    public PlaidError status(Integer status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The HTTP status code associated with the error. This will only be returned in the response body when the error information is provided via a webhook.")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public PlaidError documentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL of a Plaid documentation page with more information about the error")
    public String getDocumentationUrl() {
        return this.documentationUrl;
    }

    public void setDocumentationUrl(String documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public PlaidError suggestedAction(String suggestedAction) {
        this.suggestedAction = suggestedAction;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Suggested steps for resolving the error")
    public String getSuggestedAction() {
        return this.suggestedAction;
    }

    public void setSuggestedAction(String suggestedAction) {
        this.suggestedAction = suggestedAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaidError plaidError = (PlaidError)o;
        return Objects.equals((Object)this.errorType, (Object)plaidError.errorType) && Objects.equals(this.errorCode, plaidError.errorCode) && Objects.equals(this.errorMessage, plaidError.errorMessage) && Objects.equals(this.displayMessage, plaidError.displayMessage) && Objects.equals(this.requestId, plaidError.requestId) && Objects.equals(this.causes, plaidError.causes) && Objects.equals(this.status, plaidError.status) && Objects.equals(this.documentationUrl, plaidError.documentationUrl) && Objects.equals(this.suggestedAction, plaidError.suggestedAction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorType, this.errorCode, this.errorMessage, this.displayMessage, this.requestId, this.causes, this.status, this.documentationUrl, this.suggestedAction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlaidError {\n");
        sb.append("    errorType: ").append(this.toIndentedString((Object)this.errorType)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    displayMessage: ").append(this.toIndentedString(this.displayMessage)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    causes: ").append(this.toIndentedString(this.causes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    documentationUrl: ").append(this.toIndentedString(this.documentationUrl)).append("\n");
        sb.append("    suggestedAction: ").append(this.toIndentedString(this.suggestedAction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

