/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PrismCashScoreMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The data from the CashScore\u00ae product returned by Prism Data.")
public class PrismCashScore {
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_SCORE = "score";
    @SerializedName(value="score")
    private Integer score;
    public static final String SERIALIZED_NAME_REASON_CODES = "reason_codes";
    @SerializedName(value="reason_codes")
    private List<String> reasonCodes = null;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private PrismCashScoreMetadata metadata;

    public PrismCashScore version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="The version of Prism Data's cash score model used.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public PrismCashScore score(Integer score) {
        this.score = score;
        return this;
    }

    @ApiModelProperty(required=true, value="The score returned by Prism Data. Ranges from 1-999, with higher score indicating lower risk.")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public PrismCashScore reasonCodes(List<String> reasonCodes) {
        this.reasonCodes = reasonCodes;
        return this;
    }

    public PrismCashScore addReasonCodesItem(String reasonCodesItem) {
        if (this.reasonCodes == null) {
            this.reasonCodes = new ArrayList<String>();
        }
        this.reasonCodes.add(reasonCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reasons for an individual having risk according to the cash score.")
    public List<String> getReasonCodes() {
        return this.reasonCodes;
    }

    public void setReasonCodes(List<String> reasonCodes) {
        this.reasonCodes = reasonCodes;
    }

    public PrismCashScore metadata(PrismCashScoreMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PrismCashScoreMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(PrismCashScoreMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrismCashScore prismCashScore = (PrismCashScore)o;
        return Objects.equals(this.version, prismCashScore.version) && Objects.equals(this.score, prismCashScore.score) && Objects.equals(this.reasonCodes, prismCashScore.reasonCodes) && Objects.equals(this.metadata, prismCashScore.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.score, this.reasonCodes, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrismCashScore {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    reasonCodes: ").append(this.toIndentedString(this.reasonCodes)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

