/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing metadata about the provided transactions.")
public class PrismCashScoreMetadata {
    public static final String SERIALIZED_NAME_MAX_AGE = "max_age";
    @SerializedName(value="max_age")
    private Integer maxAge;
    public static final String SERIALIZED_NAME_MIN_AGE = "min_age";
    @SerializedName(value="min_age")
    private Integer minAge;
    public static final String SERIALIZED_NAME_MIN_AGE_CREDIT = "min_age_credit";
    @SerializedName(value="min_age_credit")
    private Integer minAgeCredit;
    public static final String SERIALIZED_NAME_MIN_AGE_DEBIT = "min_age_debit";
    @SerializedName(value="min_age_debit")
    private Integer minAgeDebit;
    public static final String SERIALIZED_NAME_MAX_AGE_DEBIT = "max_age_debit";
    @SerializedName(value="max_age_debit")
    private Integer maxAgeDebit;
    public static final String SERIALIZED_NAME_MAX_AGE_CREDIT = "max_age_credit";
    @SerializedName(value="max_age_credit")
    private Integer maxAgeCredit;
    public static final String SERIALIZED_NAME_NUM_TRXN_CREDIT = "num_trxn_credit";
    @SerializedName(value="num_trxn_credit")
    private Integer numTrxnCredit;
    public static final String SERIALIZED_NAME_NUM_TRXN_DEBIT = "num_trxn_debit";
    @SerializedName(value="num_trxn_debit")
    private Integer numTrxnDebit;
    public static final String SERIALIZED_NAME_L1M_CREDIT_VALUE_CNT = "l1m_credit_value_cnt";
    @SerializedName(value="l1m_credit_value_cnt")
    private Integer l1mCreditValueCnt;
    public static final String SERIALIZED_NAME_L1M_DEBIT_VALUE_CNT = "l1m_debit_value_cnt";
    @SerializedName(value="l1m_debit_value_cnt")
    private Integer l1mDebitValueCnt;

    public PrismCashScoreMetadata maxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of days since the oldest transaction.")
    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public PrismCashScoreMetadata minAge(Integer minAge) {
        this.minAge = minAge;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of days since the latest transaction.")
    public Integer getMinAge() {
        return this.minAge;
    }

    public void setMinAge(Integer minAge) {
        this.minAge = minAge;
    }

    public PrismCashScoreMetadata minAgeCredit(Integer minAgeCredit) {
        this.minAgeCredit = minAgeCredit;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of days since the latest credit transaction.")
    public Integer getMinAgeCredit() {
        return this.minAgeCredit;
    }

    public void setMinAgeCredit(Integer minAgeCredit) {
        this.minAgeCredit = minAgeCredit;
    }

    public PrismCashScoreMetadata minAgeDebit(Integer minAgeDebit) {
        this.minAgeDebit = minAgeDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of days since the latest debit transaction.")
    public Integer getMinAgeDebit() {
        return this.minAgeDebit;
    }

    public void setMinAgeDebit(Integer minAgeDebit) {
        this.minAgeDebit = minAgeDebit;
    }

    public PrismCashScoreMetadata maxAgeDebit(Integer maxAgeDebit) {
        this.maxAgeDebit = maxAgeDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of days since the oldest debit transaction.")
    public Integer getMaxAgeDebit() {
        return this.maxAgeDebit;
    }

    public void setMaxAgeDebit(Integer maxAgeDebit) {
        this.maxAgeDebit = maxAgeDebit;
    }

    public PrismCashScoreMetadata maxAgeCredit(Integer maxAgeCredit) {
        this.maxAgeCredit = maxAgeCredit;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of days since the oldest credit transaction.")
    public Integer getMaxAgeCredit() {
        return this.maxAgeCredit;
    }

    public void setMaxAgeCredit(Integer maxAgeCredit) {
        this.maxAgeCredit = maxAgeCredit;
    }

    public PrismCashScoreMetadata numTrxnCredit(Integer numTrxnCredit) {
        this.numTrxnCredit = numTrxnCredit;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of credit transactions.")
    public Integer getNumTrxnCredit() {
        return this.numTrxnCredit;
    }

    public void setNumTrxnCredit(Integer numTrxnCredit) {
        this.numTrxnCredit = numTrxnCredit;
    }

    public PrismCashScoreMetadata numTrxnDebit(Integer numTrxnDebit) {
        this.numTrxnDebit = numTrxnDebit;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of debit transactions.")
    public Integer getNumTrxnDebit() {
        return this.numTrxnDebit;
    }

    public void setNumTrxnDebit(Integer numTrxnDebit) {
        this.numTrxnDebit = numTrxnDebit;
    }

    public PrismCashScoreMetadata l1mCreditValueCnt(Integer l1mCreditValueCnt) {
        this.l1mCreditValueCnt = l1mCreditValueCnt;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of credit transactions in the last 30 days.")
    public Integer getL1mCreditValueCnt() {
        return this.l1mCreditValueCnt;
    }

    public void setL1mCreditValueCnt(Integer l1mCreditValueCnt) {
        this.l1mCreditValueCnt = l1mCreditValueCnt;
    }

    public PrismCashScoreMetadata l1mDebitValueCnt(Integer l1mDebitValueCnt) {
        this.l1mDebitValueCnt = l1mDebitValueCnt;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Number of debit transactions in the last 30 days.")
    public Integer getL1mDebitValueCnt() {
        return this.l1mDebitValueCnt;
    }

    public void setL1mDebitValueCnt(Integer l1mDebitValueCnt) {
        this.l1mDebitValueCnt = l1mDebitValueCnt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrismCashScoreMetadata prismCashScoreMetadata = (PrismCashScoreMetadata)o;
        return Objects.equals(this.maxAge, prismCashScoreMetadata.maxAge) && Objects.equals(this.minAge, prismCashScoreMetadata.minAge) && Objects.equals(this.minAgeCredit, prismCashScoreMetadata.minAgeCredit) && Objects.equals(this.minAgeDebit, prismCashScoreMetadata.minAgeDebit) && Objects.equals(this.maxAgeDebit, prismCashScoreMetadata.maxAgeDebit) && Objects.equals(this.maxAgeCredit, prismCashScoreMetadata.maxAgeCredit) && Objects.equals(this.numTrxnCredit, prismCashScoreMetadata.numTrxnCredit) && Objects.equals(this.numTrxnDebit, prismCashScoreMetadata.numTrxnDebit) && Objects.equals(this.l1mCreditValueCnt, prismCashScoreMetadata.l1mCreditValueCnt) && Objects.equals(this.l1mDebitValueCnt, prismCashScoreMetadata.l1mDebitValueCnt);
    }

    public int hashCode() {
        return Objects.hash(this.maxAge, this.minAge, this.minAgeCredit, this.minAgeDebit, this.maxAgeDebit, this.maxAgeCredit, this.numTrxnCredit, this.numTrxnDebit, this.l1mCreditValueCnt, this.l1mDebitValueCnt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrismCashScoreMetadata {\n");
        sb.append("    maxAge: ").append(this.toIndentedString(this.maxAge)).append("\n");
        sb.append("    minAge: ").append(this.toIndentedString(this.minAge)).append("\n");
        sb.append("    minAgeCredit: ").append(this.toIndentedString(this.minAgeCredit)).append("\n");
        sb.append("    minAgeDebit: ").append(this.toIndentedString(this.minAgeDebit)).append("\n");
        sb.append("    maxAgeDebit: ").append(this.toIndentedString(this.maxAgeDebit)).append("\n");
        sb.append("    maxAgeCredit: ").append(this.toIndentedString(this.maxAgeCredit)).append("\n");
        sb.append("    numTrxnCredit: ").append(this.toIndentedString(this.numTrxnCredit)).append("\n");
        sb.append("    numTrxnDebit: ").append(this.toIndentedString(this.numTrxnDebit)).append("\n");
        sb.append("    l1mCreditValueCnt: ").append(this.toIndentedString(this.l1mCreditValueCnt)).append("\n");
        sb.append("    l1mDebitValueCnt: ").append(this.toIndentedString(this.l1mDebitValueCnt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

