/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The data from the Insights product returned by Prism Data.")
public class PrismInsights {
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;
    public static final String SERIALIZED_NAME_RESULT = "result";
    @SerializedName(value="result")
    private Object result;

    public PrismInsights version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="The version of Prism Data's insights model used.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public PrismInsights result(Object result) {
        this.result = result;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Insights Result object is a map of cash flow attributes, where the key is a string, and the value is a float or string.")
    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrismInsights prismInsights = (PrismInsights)o;
        return Objects.equals(this.version, prismInsights.version) && Objects.equals(this.result, prismInsights.result);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrismInsights {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    result: ").append(this.toIndentedString(this.result)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

