/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Optional parameters to `/processor/balance/get`.")
public class ProcessorBalanceGetRequestOptions {
    public static final String SERIALIZED_NAME_MIN_LAST_UPDATED_DATETIME = "min_last_updated_datetime";
    @SerializedName(value="min_last_updated_datetime")
    private OffsetDateTime minLastUpdatedDatetime;

    public ProcessorBalanceGetRequestOptions minLastUpdatedDatetime(OffsetDateTime minLastUpdatedDatetime) {
        this.minLastUpdatedDatetime = minLastUpdatedDatetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the oldest acceptable balance when making a request to `/accounts/balance/get`.  This field is only necessary when the institution is `ins_128026` (Capital One), *and* one or more account types being requested is a non-depository account (such as a credit card) as Capital One does not provide real-time balance for non-depository accounts. In this case, a value must be provided or an `INVALID_REQUEST` error with the code of `INVALID_FIELD` will be returned. For all other institutions, as well as for depository accounts at Capital One (including all checking and savings accounts) this field is ignored and real-time balance information will be fetched.  If this field is not ignored, and no acceptable balance is available, an `INVALID_RESULT` error with the code `LAST_UPDATED_DATETIME_OUT_OF_RANGE` will be returned.")
    public OffsetDateTime getMinLastUpdatedDatetime() {
        return this.minLastUpdatedDatetime;
    }

    public void setMinLastUpdatedDatetime(OffsetDateTime minLastUpdatedDatetime) {
        this.minLastUpdatedDatetime = minLastUpdatedDatetime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorBalanceGetRequestOptions processorBalanceGetRequestOptions = (ProcessorBalanceGetRequestOptions)o;
        return Objects.equals(this.minLastUpdatedDatetime, processorBalanceGetRequestOptions.minLastUpdatedDatetime);
    }

    public int hashCode() {
        return Objects.hash(this.minLastUpdatedDatetime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorBalanceGetRequestOptions {\n");
        sb.append("    minLastUpdatedDatetime: ").append(this.toIndentedString(this.minLastUpdatedDatetime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

