/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.BankTransferNetwork;
import com.plaid.client.model.BankTransferType;
import com.plaid.client.model.BankTransferUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/processor/bank_transfer/create`")
public class ProcessorBankTransferCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_IDEMPOTENCY_KEY = "idempotency_key";
    @SerializedName(value="idempotency_key")
    private String idempotencyKey;
    public static final String SERIALIZED_NAME_PROCESSOR_TOKEN = "processor_token";
    @SerializedName(value="processor_token")
    private String processorToken;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private BankTransferType type;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private BankTransferNetwork network;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private BankTransferUser user;
    public static final String SERIALIZED_NAME_CUSTOM_TAG = "custom_tag";
    @SerializedName(value="custom_tag")
    private String customTag;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;

    public ProcessorBankTransferCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ProcessorBankTransferCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ProcessorBankTransferCreateRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="A random key provided by the client, per unique bank transfer. Maximum of 50 characters.  The API supports idempotency for safely retrying requests without accidentally performing the same operation twice. For example, if a request to create a bank transfer fails due to a network connection error, you can retry the request with the same idempotency key to guarantee that only a single bank transfer is created.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public ProcessorBankTransferCreateRequest processorToken(String processorToken) {
        this.processorToken = processorToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The processor token obtained from the Plaid integration partner. Processor tokens are in the format: `processor-<environment>-<identifier>`")
    public String getProcessorToken() {
        return this.processorToken;
    }

    public void setProcessorToken(String processorToken) {
        this.processorToken = processorToken;
    }

    public ProcessorBankTransferCreateRequest type(BankTransferType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankTransferType getType() {
        return this.type;
    }

    public void setType(BankTransferType type) {
        this.type = type;
    }

    public ProcessorBankTransferCreateRequest network(BankTransferNetwork network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankTransferNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(BankTransferNetwork network) {
        this.network = network;
    }

    public ProcessorBankTransferCreateRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the bank transfer (decimal string with two digits of precision e.g. \"10.00\").")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public ProcessorBankTransferCreateRequest isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the transfer amount \u2013 should be set to \"USD\".")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public ProcessorBankTransferCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The transfer description. Maximum of 10 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProcessorBankTransferCreateRequest achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public ProcessorBankTransferCreateRequest user(BankTransferUser user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public BankTransferUser getUser() {
        return this.user;
    }

    public void setUser(BankTransferUser user) {
        this.user = user;
    }

    public ProcessorBankTransferCreateRequest customTag(String customTag) {
        this.customTag = customTag;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An arbitrary string provided by the client for storage with the bank transfer. May be up to 100 characters.")
    public String getCustomTag() {
        return this.customTag;
    }

    public void setCustomTag(String customTag) {
        this.customTag = customTag;
    }

    public ProcessorBankTransferCreateRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ProcessorBankTransferCreateRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: The JSON values must be Strings (no nested JSON objects allowed) Only ASCII characters may be used Maximum of 50 key/value pairs Maximum key length of 40 characters Maximum value length of 500 characters ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public ProcessorBankTransferCreateRequest originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for the origination account for this transfer. If you have more than one origination account, this value must be specified.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorBankTransferCreateRequest processorBankTransferCreateRequest = (ProcessorBankTransferCreateRequest)o;
        return Objects.equals(this.clientId, processorBankTransferCreateRequest.clientId) && Objects.equals(this.secret, processorBankTransferCreateRequest.secret) && Objects.equals(this.idempotencyKey, processorBankTransferCreateRequest.idempotencyKey) && Objects.equals(this.processorToken, processorBankTransferCreateRequest.processorToken) && Objects.equals((Object)this.type, (Object)processorBankTransferCreateRequest.type) && Objects.equals((Object)this.network, (Object)processorBankTransferCreateRequest.network) && Objects.equals(this.amount, processorBankTransferCreateRequest.amount) && Objects.equals(this.isoCurrencyCode, processorBankTransferCreateRequest.isoCurrencyCode) && Objects.equals(this.description, processorBankTransferCreateRequest.description) && Objects.equals((Object)this.achClass, (Object)processorBankTransferCreateRequest.achClass) && Objects.equals(this.user, processorBankTransferCreateRequest.user) && Objects.equals(this.customTag, processorBankTransferCreateRequest.customTag) && Objects.equals(this.metadata, processorBankTransferCreateRequest.metadata) && Objects.equals(this.originationAccountId, processorBankTransferCreateRequest.originationAccountId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.idempotencyKey, this.processorToken, this.type, this.network, this.amount, this.isoCurrencyCode, this.description, this.achClass, this.user, this.customTag, this.metadata, this.originationAccountId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorBankTransferCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    processorToken: ").append(this.toIndentedString(this.processorToken)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    customTag: ").append(this.toIndentedString(this.customTag)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

