/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.NumbersACHNullable;
import com.plaid.client.model.NumbersBACSNullable;
import com.plaid.client.model.NumbersEFTNullable;
import com.plaid.client.model.NumbersInternationalNullable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing identifying numbers used for making electronic transfers to and from the `account`. The identifying number type (ACH, EFT, IBAN, or BACS) used will depend on the country of the account. An account may have more than one number type. If a particular identifying number type is not used by the `account` for which auth data has been requested, a null value will be returned.")
public class ProcessorNumber {
    public static final String SERIALIZED_NAME_ACH = "ach";
    @SerializedName(value="ach")
    private NumbersACHNullable ach;
    public static final String SERIALIZED_NAME_EFT = "eft";
    @SerializedName(value="eft")
    private NumbersEFTNullable eft;
    public static final String SERIALIZED_NAME_INTERNATIONAL = "international";
    @SerializedName(value="international")
    private NumbersInternationalNullable international;
    public static final String SERIALIZED_NAME_BACS = "bacs";
    @SerializedName(value="bacs")
    private NumbersBACSNullable bacs;

    public ProcessorNumber ach(NumbersACHNullable ach) {
        this.ach = ach;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NumbersACHNullable getAch() {
        return this.ach;
    }

    public void setAch(NumbersACHNullable ach) {
        this.ach = ach;
    }

    public ProcessorNumber eft(NumbersEFTNullable eft) {
        this.eft = eft;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NumbersEFTNullable getEft() {
        return this.eft;
    }

    public void setEft(NumbersEFTNullable eft) {
        this.eft = eft;
    }

    public ProcessorNumber international(NumbersInternationalNullable international) {
        this.international = international;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NumbersInternationalNullable getInternational() {
        return this.international;
    }

    public void setInternational(NumbersInternationalNullable international) {
        this.international = international;
    }

    public ProcessorNumber bacs(NumbersBACSNullable bacs) {
        this.bacs = bacs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public NumbersBACSNullable getBacs() {
        return this.bacs;
    }

    public void setBacs(NumbersBACSNullable bacs) {
        this.bacs = bacs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorNumber processorNumber = (ProcessorNumber)o;
        return Objects.equals(this.ach, processorNumber.ach) && Objects.equals(this.eft, processorNumber.eft) && Objects.equals(this.international, processorNumber.international) && Objects.equals(this.bacs, processorNumber.bacs);
    }

    public int hashCode() {
        return Objects.hash(this.ach, this.eft, this.international, this.bacs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorNumber {\n");
        sb.append("    ach: ").append(this.toIndentedString(this.ach)).append("\n");
        sb.append("    eft: ").append(this.toIndentedString(this.eft)).append("\n");
        sb.append("    international: ").append(this.toIndentedString(this.international)).append("\n");
        sb.append("    bacs: ").append(this.toIndentedString(this.bacs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

