/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.SignalDevice;
import com.plaid.client.model.SignalUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ProcessorSignalEvaluateRequest defines the request schema for `/processor/signal/evaluate`")
public class ProcessorSignalEvaluateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_PROCESSOR_TOKEN = "processor_token";
    @SerializedName(value="processor_token")
    private String processorToken;
    public static final String SERIALIZED_NAME_CLIENT_TRANSACTION_ID = "client_transaction_id";
    @SerializedName(value="client_transaction_id")
    private String clientTransactionId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Double amount;
    public static final String SERIALIZED_NAME_USER_PRESENT = "user_present";
    @SerializedName(value="user_present")
    private Boolean userPresent;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_IS_RECURRING = "is_recurring";
    @SerializedName(value="is_recurring")
    private Boolean isRecurring;
    public static final String SERIALIZED_NAME_DEFAULT_PAYMENT_METHOD = "default_payment_method";
    @SerializedName(value="default_payment_method")
    private String defaultPaymentMethod;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private SignalUser user;
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    private SignalDevice device;

    public ProcessorSignalEvaluateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ProcessorSignalEvaluateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ProcessorSignalEvaluateRequest processorToken(String processorToken) {
        this.processorToken = processorToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The processor token obtained from the Plaid integration partner. Processor tokens are in the format: `processor-<environment>-<identifier>`")
    public String getProcessorToken() {
        return this.processorToken;
    }

    public void setProcessorToken(String processorToken) {
        this.processorToken = processorToken;
    }

    public ProcessorSignalEvaluateRequest clientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique ID that you would like to use to refer to this transaction. For your convenience mapping your internal data, you could use your internal ID/identifier for this transaction. The max length for this field is 36 characters.")
    public String getClientTransactionId() {
        return this.clientTransactionId;
    }

    public void setClientTransactionId(String clientTransactionId) {
        this.clientTransactionId = clientTransactionId;
    }

    public ProcessorSignalEvaluateRequest amount(Double amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The transaction amount, in USD (e.g. `102.05`)")
    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public ProcessorSignalEvaluateRequest userPresent(Boolean userPresent) {
        this.userPresent = userPresent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`true` if the end user is present while initiating the ACH transfer and the endpoint is being called; `false` otherwise (for example, when the ACH transfer is scheduled and the end user is not present, or you call this endpoint after the ACH transfer but before submitting the Nacha file for ACH processing).")
    public Boolean getUserPresent() {
        return this.userPresent;
    }

    public void setUserPresent(Boolean userPresent) {
        this.userPresent = userPresent;
    }

    public ProcessorSignalEvaluateRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique ID that identifies the end user in your system. This ID is used to correlate requests by a user with multiple Items. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public ProcessorSignalEvaluateRequest isRecurring(Boolean isRecurring) {
        this.isRecurring = isRecurring;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**true** if the ACH transaction is a recurring transaction; **false** otherwise ")
    public Boolean getIsRecurring() {
        return this.isRecurring;
    }

    public void setIsRecurring(Boolean isRecurring) {
        this.isRecurring = isRecurring;
    }

    public ProcessorSignalEvaluateRequest defaultPaymentMethod(String defaultPaymentMethod) {
        this.defaultPaymentMethod = defaultPaymentMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The default ACH or non-ACH payment method to complete the transaction. `SAME_DAY_ACH`: Same Day ACH by NACHA. The debit transaction is processed and settled on the same day `NEXT_DAY_ACH`: Next Day ACH settlement for debit transactions, offered by some payment processors `STANDARD_ACH`: standard ACH by NACHA `REAL_TIME_PAYMENTS`: real-time payments such as RTP and FedNow `DEBIT_CARD`: if the default payment is over debit card networks `MULTIPLE_PAYMENT_METHODS`: if there is no default debit rail or there are multiple payment methods Possible values:  `SAME_DAY_ACH`, `NEXT_DAY_ACH`, `STANDARD_ACH`, `REAL_TIME_PAYMENTS`, `DEBIT_CARD`, `MULTIPLE_PAYMENT_METHODS`")
    public String getDefaultPaymentMethod() {
        return this.defaultPaymentMethod;
    }

    public void setDefaultPaymentMethod(String defaultPaymentMethod) {
        this.defaultPaymentMethod = defaultPaymentMethod;
    }

    public ProcessorSignalEvaluateRequest user(SignalUser user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SignalUser getUser() {
        return this.user;
    }

    public void setUser(SignalUser user) {
        this.user = user;
    }

    public ProcessorSignalEvaluateRequest device(SignalDevice device) {
        this.device = device;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SignalDevice getDevice() {
        return this.device;
    }

    public void setDevice(SignalDevice device) {
        this.device = device;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorSignalEvaluateRequest processorSignalEvaluateRequest = (ProcessorSignalEvaluateRequest)o;
        return Objects.equals(this.clientId, processorSignalEvaluateRequest.clientId) && Objects.equals(this.secret, processorSignalEvaluateRequest.secret) && Objects.equals(this.processorToken, processorSignalEvaluateRequest.processorToken) && Objects.equals(this.clientTransactionId, processorSignalEvaluateRequest.clientTransactionId) && Objects.equals(this.amount, processorSignalEvaluateRequest.amount) && Objects.equals(this.userPresent, processorSignalEvaluateRequest.userPresent) && Objects.equals(this.clientUserId, processorSignalEvaluateRequest.clientUserId) && Objects.equals(this.isRecurring, processorSignalEvaluateRequest.isRecurring) && Objects.equals(this.defaultPaymentMethod, processorSignalEvaluateRequest.defaultPaymentMethod) && Objects.equals(this.user, processorSignalEvaluateRequest.user) && Objects.equals(this.device, processorSignalEvaluateRequest.device);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.processorToken, this.clientTransactionId, this.amount, this.userPresent, this.clientUserId, this.isRecurring, this.defaultPaymentMethod, this.user, this.device);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorSignalEvaluateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    processorToken: ").append(this.toIndentedString(this.processorToken)).append("\n");
        sb.append("    clientTransactionId: ").append(this.toIndentedString(this.clientTransactionId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    userPresent: ").append(this.toIndentedString(this.userPresent)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    isRecurring: ").append(this.toIndentedString(this.isRecurring)).append("\n");
        sb.append("    defaultPaymentMethod: ").append(this.toIndentedString(this.defaultPaymentMethod)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

