/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.SignalEvaluateCoreAttributes;
import com.plaid.client.model.SignalScores;
import com.plaid.client.model.SignalWarning;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ProcessorSignalEvaluateResponse defines the response schema for `/processor/signal/evaluate`")
public class ProcessorSignalEvaluateResponse {
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_SCORES = "scores";
    @SerializedName(value="scores")
    private SignalScores scores;
    public static final String SERIALIZED_NAME_CORE_ATTRIBUTES = "core_attributes";
    @SerializedName(value="core_attributes")
    private SignalEvaluateCoreAttributes coreAttributes;
    public static final String SERIALIZED_NAME_WARNINGS = "warnings";
    @SerializedName(value="warnings")
    private List<SignalWarning> warnings = null;

    public ProcessorSignalEvaluateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public ProcessorSignalEvaluateResponse scores(SignalScores scores) {
        this.scores = scores;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public SignalScores getScores() {
        return this.scores;
    }

    public void setScores(SignalScores scores) {
        this.scores = scores;
    }

    public ProcessorSignalEvaluateResponse coreAttributes(SignalEvaluateCoreAttributes coreAttributes) {
        this.coreAttributes = coreAttributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SignalEvaluateCoreAttributes getCoreAttributes() {
        return this.coreAttributes;
    }

    public void setCoreAttributes(SignalEvaluateCoreAttributes coreAttributes) {
        this.coreAttributes = coreAttributes;
    }

    public ProcessorSignalEvaluateResponse warnings(List<SignalWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public ProcessorSignalEvaluateResponse addWarningsItem(SignalWarning warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<SignalWarning>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If bank information was not available to be used in the Signal model, this array contains warnings describing why bank data is missing. If you want to receive an API error instead of Signal scores in the case of missing bank data, file a support ticket or contact your Plaid account manager.")
    public List<SignalWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<SignalWarning> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorSignalEvaluateResponse processorSignalEvaluateResponse = (ProcessorSignalEvaluateResponse)o;
        return Objects.equals(this.requestId, processorSignalEvaluateResponse.requestId) && Objects.equals(this.scores, processorSignalEvaluateResponse.scores) && Objects.equals(this.coreAttributes, processorSignalEvaluateResponse.coreAttributes) && Objects.equals(this.warnings, processorSignalEvaluateResponse.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.scores, this.coreAttributes, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorSignalEvaluateResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    scores: ").append(this.toIndentedString(this.scores)).append("\n");
        sb.append("    coreAttributes: ").append(this.toIndentedString(this.coreAttributes)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

