/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ProcessorTokenCreateRequest defines the request schema for `/processor/token/create`")
public class ProcessorTokenCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_PROCESSOR = "processor";
    @SerializedName(value="processor")
    private ProcessorEnum processor;

    public ProcessorTokenCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ProcessorTokenCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ProcessorTokenCreateRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public ProcessorTokenCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `account_id` value obtained from the `onSuccess` callback in Link")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public ProcessorTokenCreateRequest processor(ProcessorEnum processor) {
        this.processor = processor;
        return this;
    }

    @ApiModelProperty(required=true, value="The processor you are integrating with.")
    public ProcessorEnum getProcessor() {
        return this.processor;
    }

    public void setProcessor(ProcessorEnum processor) {
        this.processor = processor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorTokenCreateRequest processorTokenCreateRequest = (ProcessorTokenCreateRequest)o;
        return Objects.equals(this.clientId, processorTokenCreateRequest.clientId) && Objects.equals(this.secret, processorTokenCreateRequest.secret) && Objects.equals(this.accessToken, processorTokenCreateRequest.accessToken) && Objects.equals(this.accountId, processorTokenCreateRequest.accountId) && Objects.equals((Object)this.processor, (Object)processorTokenCreateRequest.processor);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.accessToken, this.accountId, this.processor});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorTokenCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    processor: ").append(this.toIndentedString((Object)this.processor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProcessorEnum {
        DWOLLA("dwolla"),
        GALILEO("galileo"),
        MODERN_TREASURY("modern_treasury"),
        OCROLUS("ocrolus"),
        VESTA("vesta"),
        DRIVEWEALTH("drivewealth"),
        VOPAY("vopay"),
        ACHQ("achq"),
        CHECK("check"),
        CHECKBOOK("checkbook"),
        CIRCLE("circle"),
        SILA_MONEY("sila_money"),
        RIZE("rize"),
        SVB_API("svb_api"),
        UNIT("unit"),
        WYRE("wyre"),
        LITHIC("lithic"),
        ALPACA("alpaca"),
        ASTRA("astra"),
        MOOV("moov"),
        TREASURY_PRIME("treasury_prime"),
        MARQETA("marqeta"),
        CHECKOUT("checkout"),
        SOLID("solid"),
        HIGHNOTE("highnote"),
        GEMINI("gemini"),
        APEX_CLEARING("apex_clearing"),
        GUSTO("gusto"),
        ADYEN("adyen"),
        ATOMIC("atomic"),
        I2C("i2c"),
        WEPAY("wepay"),
        RISKIFIED("riskified"),
        UTB("utb"),
        ADP_ROLL("adp_roll"),
        FORTRESS_TRUST("fortress_trust"),
        BOND("bond"),
        BAKKT("bakkt"),
        TEAL("teal"),
        ZERO_HASH("zero_hash"),
        TABA_PAY("taba_pay"),
        KNOT("knot"),
        SARDINE("sardine"),
        ALLOY("alloy"),
        FINIX("finix"),
        NUVEI("nuvei"),
        LAYER("layer"),
        BOOM("boom"),
        PAYNOTE("paynote");

        private String value;

        private ProcessorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProcessorEnum fromValue(String value) {
            for (ProcessorEnum b : ProcessorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ProcessorEnum> {
            public void write(JsonWriter jsonWriter, ProcessorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProcessorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProcessorEnum.fromValue(value);
            }
        }
    }
}

