/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ProcessorTokenPermissionsGetRequest defines the request schema for `/processor/token/permissions/get`")
public class ProcessorTokenPermissionsGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_PROCESSOR_TOKEN = "processor_token";
    @SerializedName(value="processor_token")
    private String processorToken;

    public ProcessorTokenPermissionsGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ProcessorTokenPermissionsGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ProcessorTokenPermissionsGetRequest processorToken(String processorToken) {
        this.processorToken = processorToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The processor token obtained from the Plaid integration partner. Processor tokens are in the format: `processor-<environment>-<identifier>`")
    public String getProcessorToken() {
        return this.processorToken;
    }

    public void setProcessorToken(String processorToken) {
        this.processorToken = processorToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorTokenPermissionsGetRequest processorTokenPermissionsGetRequest = (ProcessorTokenPermissionsGetRequest)o;
        return Objects.equals(this.clientId, processorTokenPermissionsGetRequest.clientId) && Objects.equals(this.secret, processorTokenPermissionsGetRequest.secret) && Objects.equals(this.processorToken, processorTokenPermissionsGetRequest.processorToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.processorToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorTokenPermissionsGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    processorToken: ").append(this.toIndentedString(this.processorToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

