/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Products;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="ProcessorTokenPermissionsGetResponse defines the response schema for `/processor/token/permissions/get`")
public class ProcessorTokenPermissionsGetResponse {
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<Products> products = new ArrayList<Products>();

    public ProcessorTokenPermissionsGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public ProcessorTokenPermissionsGetResponse products(List<Products> products) {
        this.products = products;
        return this;
    }

    public ProcessorTokenPermissionsGetResponse addProductsItem(Products productsItem) {
        this.products.add(productsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of products the processor token should have access to. An empty list means that the processor has access to all available products, including future products.")
    public List<Products> getProducts() {
        return this.products;
    }

    public void setProducts(List<Products> products) {
        this.products = products;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorTokenPermissionsGetResponse processorTokenPermissionsGetResponse = (ProcessorTokenPermissionsGetResponse)o;
        return Objects.equals(this.requestId, processorTokenPermissionsGetResponse.requestId) && Objects.equals(this.products, processorTokenPermissionsGetResponse.products);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.products);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorTokenPermissionsGetResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

