/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="This webhook is only sent to [Plaid processor partners](https://plaid.com/docs/auth/partnerships/).  Fired when a processor updates the webhook URL for a processor token via `/processor/token/webhook/update`.")
public class ProcessorTokenWebhookUpdate {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_NEW_WEBHOOK_URL = "new_webhook_url";
    @SerializedName(value="new_webhook_url")
    private String newWebhookUrl;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public ProcessorTokenWebhookUpdate webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`PROCESSOR_TOKEN`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public ProcessorTokenWebhookUpdate webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`WEBHOOK_UPDATE_ACKNOWLEDGED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public ProcessorTokenWebhookUpdate error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public ProcessorTokenWebhookUpdate accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public ProcessorTokenWebhookUpdate newWebhookUrl(String newWebhookUrl) {
        this.newWebhookUrl = newWebhookUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The new webhook URL.")
    public String getNewWebhookUrl() {
        return this.newWebhookUrl;
    }

    public void setNewWebhookUrl(String newWebhookUrl) {
        this.newWebhookUrl = newWebhookUrl;
    }

    public ProcessorTokenWebhookUpdate environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorTokenWebhookUpdate processorTokenWebhookUpdate = (ProcessorTokenWebhookUpdate)o;
        return Objects.equals(this.webhookType, processorTokenWebhookUpdate.webhookType) && Objects.equals(this.webhookCode, processorTokenWebhookUpdate.webhookCode) && Objects.equals(this.error, processorTokenWebhookUpdate.error) && Objects.equals(this.accountId, processorTokenWebhookUpdate.accountId) && Objects.equals(this.newWebhookUrl, processorTokenWebhookUpdate.newWebhookUrl) && Objects.equals((Object)this.environment, (Object)processorTokenWebhookUpdate.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.error, this.accountId, this.newWebhookUrl, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorTokenWebhookUpdate {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    newWebhookUrl: ").append(this.toIndentedString(this.newWebhookUrl)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

