/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ProcessorTokenWebhookUpdateRequest defines the request schema for `/processor/token/webhook/update`")
public class ProcessorTokenWebhookUpdateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_PROCESSOR_TOKEN = "processor_token";
    @SerializedName(value="processor_token")
    private String processorToken;
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private String webhook;

    public ProcessorTokenWebhookUpdateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ProcessorTokenWebhookUpdateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ProcessorTokenWebhookUpdateRequest processorToken(String processorToken) {
        this.processorToken = processorToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The processor token obtained from the Plaid integration partner. Processor tokens are in the format: `processor-<environment>-<identifier>`")
    public String getProcessorToken() {
        return this.processorToken;
    }

    public void setProcessorToken(String processorToken) {
        this.processorToken = processorToken;
    }

    public ProcessorTokenWebhookUpdateRequest webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The new webhook URL to associate with the processor token. To remove a webhook from a processor token, set to `null`.")
    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorTokenWebhookUpdateRequest processorTokenWebhookUpdateRequest = (ProcessorTokenWebhookUpdateRequest)o;
        return Objects.equals(this.clientId, processorTokenWebhookUpdateRequest.clientId) && Objects.equals(this.secret, processorTokenWebhookUpdateRequest.secret) && Objects.equals(this.processorToken, processorTokenWebhookUpdateRequest.processorToken) && Objects.equals(this.webhook, processorTokenWebhookUpdateRequest.webhook);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.processorToken, this.webhook);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorTokenWebhookUpdateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    processorToken: ").append(this.toIndentedString(this.processorToken)).append("\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

