/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountBase;
import com.plaid.client.model.Transaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="ProcessorTransactionsGetResponse defines the response schema for `/processor/transactions/get`")
public class ProcessorTransactionsGetResponse {
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private AccountBase account;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<Transaction> transactions = new ArrayList<Transaction>();
    public static final String SERIALIZED_NAME_TOTAL_TRANSACTIONS = "total_transactions";
    @SerializedName(value="total_transactions")
    private Integer totalTransactions;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public ProcessorTransactionsGetResponse account(AccountBase account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AccountBase getAccount() {
        return this.account;
    }

    public void setAccount(AccountBase account) {
        this.account = account;
    }

    public ProcessorTransactionsGetResponse transactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public ProcessorTransactionsGetResponse addTransactionsItem(Transaction transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array containing transactions from the account. Transactions are returned in reverse chronological order, with the most recent at the beginning of the array. The maximum number of transactions returned is determined by the `count` parameter.")
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    public ProcessorTransactionsGetResponse totalTransactions(Integer totalTransactions) {
        this.totalTransactions = totalTransactions;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of transactions available within the date range specified. If `total_transactions` is larger than the size of the `transactions` array, more transactions are available and can be fetched via manipulating the `offset` parameter.")
    public Integer getTotalTransactions() {
        return this.totalTransactions;
    }

    public void setTotalTransactions(Integer totalTransactions) {
        this.totalTransactions = totalTransactions;
    }

    public ProcessorTransactionsGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorTransactionsGetResponse processorTransactionsGetResponse = (ProcessorTransactionsGetResponse)o;
        return Objects.equals(this.account, processorTransactionsGetResponse.account) && Objects.equals(this.transactions, processorTransactionsGetResponse.transactions) && Objects.equals(this.totalTransactions, processorTransactionsGetResponse.totalTransactions) && Objects.equals(this.requestId, processorTransactionsGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.transactions, this.totalTransactions, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorTransactionsGetResponse {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    totalTransactions: ").append(this.toIndentedString(this.totalTransactions)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

