/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransactionStream;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="ProcessorTransactionsRecurringGetResponse defines the response schema for `/processor/transactions/recurring/get`")
public class ProcessorTransactionsRecurringGetResponse {
    public static final String SERIALIZED_NAME_INFLOW_STREAMS = "inflow_streams";
    @SerializedName(value="inflow_streams")
    private List<TransactionStream> inflowStreams = new ArrayList<TransactionStream>();
    public static final String SERIALIZED_NAME_OUTFLOW_STREAMS = "outflow_streams";
    @SerializedName(value="outflow_streams")
    private List<TransactionStream> outflowStreams = new ArrayList<TransactionStream>();
    public static final String SERIALIZED_NAME_UPDATED_DATETIME = "updated_datetime";
    @SerializedName(value="updated_datetime")
    private OffsetDateTime updatedDatetime;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public ProcessorTransactionsRecurringGetResponse inflowStreams(List<TransactionStream> inflowStreams) {
        this.inflowStreams = inflowStreams;
        return this;
    }

    public ProcessorTransactionsRecurringGetResponse addInflowStreamsItem(TransactionStream inflowStreamsItem) {
        this.inflowStreams.add(inflowStreamsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of depository transaction streams.")
    public List<TransactionStream> getInflowStreams() {
        return this.inflowStreams;
    }

    public void setInflowStreams(List<TransactionStream> inflowStreams) {
        this.inflowStreams = inflowStreams;
    }

    public ProcessorTransactionsRecurringGetResponse outflowStreams(List<TransactionStream> outflowStreams) {
        this.outflowStreams = outflowStreams;
        return this;
    }

    public ProcessorTransactionsRecurringGetResponse addOutflowStreamsItem(TransactionStream outflowStreamsItem) {
        this.outflowStreams.add(outflowStreamsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of expense transaction streams.")
    public List<TransactionStream> getOutflowStreams() {
        return this.outflowStreams;
    }

    public void setOutflowStreams(List<TransactionStream> outflowStreams) {
        this.outflowStreams = outflowStreams;
    }

    public ProcessorTransactionsRecurringGetResponse updatedDatetime(OffsetDateTime updatedDatetime) {
        this.updatedDatetime = updatedDatetime;
        return this;
    }

    @ApiModelProperty(required=true, value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (`YYYY-MM-DDTHH:mm:ssZ`) indicating the last time transaction streams for the given account were updated on")
    public OffsetDateTime getUpdatedDatetime() {
        return this.updatedDatetime;
    }

    public void setUpdatedDatetime(OffsetDateTime updatedDatetime) {
        this.updatedDatetime = updatedDatetime;
    }

    public ProcessorTransactionsRecurringGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorTransactionsRecurringGetResponse processorTransactionsRecurringGetResponse = (ProcessorTransactionsRecurringGetResponse)o;
        return Objects.equals(this.inflowStreams, processorTransactionsRecurringGetResponse.inflowStreams) && Objects.equals(this.outflowStreams, processorTransactionsRecurringGetResponse.outflowStreams) && Objects.equals(this.updatedDatetime, processorTransactionsRecurringGetResponse.updatedDatetime) && Objects.equals(this.requestId, processorTransactionsRecurringGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.inflowStreams, this.outflowStreams, this.updatedDatetime, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorTransactionsRecurringGetResponse {\n");
        sb.append("    inflowStreams: ").append(this.toIndentedString(this.inflowStreams)).append("\n");
        sb.append("    outflowStreams: ").append(this.toIndentedString(this.outflowStreams)).append("\n");
        sb.append("    updatedDatetime: ").append(this.toIndentedString(this.updatedDatetime)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

