/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PlaidError;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="This webhook is only sent to [Plaid processor partners](https://plaid.com/docs/auth/partnerships/).  Fired when transaction(s) for an Item are deleted. The deleted transaction IDs are included in the webhook payload. Plaid will typically check for deleted transaction data several times a day.  This webhook is intended for use with `/processor/transactions/get`; if you are using the newer `/processor/transactions/sync` endpoint, this webhook will still be fired to maintain backwards compatibility, but it is recommended to listen for and respond to the `SYNC_UPDATES_AVAILABLE` webhook instead.")
public class ProcessorTransactionsRemovedWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    private PlaidError error;
    public static final String SERIALIZED_NAME_REMOVED_TRANSACTIONS = "removed_transactions";
    @SerializedName(value="removed_transactions")
    private List<String> removedTransactions = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public ProcessorTransactionsRemovedWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`TRANSACTIONS`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public ProcessorTransactionsRemovedWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`TRANSACTIONS_REMOVED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public ProcessorTransactionsRemovedWebhook error(PlaidError error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlaidError getError() {
        return this.error;
    }

    public void setError(PlaidError error) {
        this.error = error;
    }

    public ProcessorTransactionsRemovedWebhook removedTransactions(List<String> removedTransactions) {
        this.removedTransactions = removedTransactions;
        return this;
    }

    public ProcessorTransactionsRemovedWebhook addRemovedTransactionsItem(String removedTransactionsItem) {
        this.removedTransactions.add(removedTransactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of `transaction_ids` corresponding to the removed transactions")
    public List<String> getRemovedTransactions() {
        return this.removedTransactions;
    }

    public void setRemovedTransactions(List<String> removedTransactions) {
        this.removedTransactions = removedTransactions;
    }

    public ProcessorTransactionsRemovedWebhook accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public ProcessorTransactionsRemovedWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorTransactionsRemovedWebhook processorTransactionsRemovedWebhook = (ProcessorTransactionsRemovedWebhook)o;
        return Objects.equals(this.webhookType, processorTransactionsRemovedWebhook.webhookType) && Objects.equals(this.webhookCode, processorTransactionsRemovedWebhook.webhookCode) && Objects.equals(this.error, processorTransactionsRemovedWebhook.error) && Objects.equals(this.removedTransactions, processorTransactionsRemovedWebhook.removedTransactions) && Objects.equals(this.accountId, processorTransactionsRemovedWebhook.accountId) && Objects.equals((Object)this.environment, (Object)processorTransactionsRemovedWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.error, this.removedTransactions, this.accountId, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorTransactionsRemovedWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    removedTransactions: ").append(this.toIndentedString(this.removedTransactions)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

