/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransactionsSyncRequestOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ProcessorTransactionsSyncRequest defines the request schema for `/processor/transactions/sync`")
public class ProcessorTransactionsSyncRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_PROCESSOR_TOKEN = "processor_token";
    @SerializedName(value="processor_token")
    private String processorToken;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CURSOR = "cursor";
    @SerializedName(value="cursor")
    private String cursor;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 100;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private TransactionsSyncRequestOptions options;

    public ProcessorTransactionsSyncRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ProcessorTransactionsSyncRequest processorToken(String processorToken) {
        this.processorToken = processorToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The processor token obtained from the Plaid integration partner. Processor tokens are in the format: `processor-<environment>-<identifier>`")
    public String getProcessorToken() {
        return this.processorToken;
    }

    public void setProcessorToken(String processorToken) {
        this.processorToken = processorToken;
    }

    public ProcessorTransactionsSyncRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ProcessorTransactionsSyncRequest cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The cursor value represents the last update requested. Providing it will cause the response to only return changes after this update. If omitted, the entire history of updates will be returned, starting with the first-added transactions on the item. Note: The upper-bound length of this cursor is 256 characters of base64.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public ProcessorTransactionsSyncRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of transaction updates to fetch.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public ProcessorTransactionsSyncRequest options(TransactionsSyncRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransactionsSyncRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(TransactionsSyncRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorTransactionsSyncRequest processorTransactionsSyncRequest = (ProcessorTransactionsSyncRequest)o;
        return Objects.equals(this.clientId, processorTransactionsSyncRequest.clientId) && Objects.equals(this.processorToken, processorTransactionsSyncRequest.processorToken) && Objects.equals(this.secret, processorTransactionsSyncRequest.secret) && Objects.equals(this.cursor, processorTransactionsSyncRequest.cursor) && Objects.equals(this.count, processorTransactionsSyncRequest.count) && Objects.equals(this.options, processorTransactionsSyncRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.processorToken, this.secret, this.cursor, this.count, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorTransactionsSyncRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    processorToken: ").append(this.toIndentedString(this.processorToken)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

