/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AccountBase;
import com.plaid.client.model.RemovedTransaction;
import com.plaid.client.model.Transaction;
import com.plaid.client.model.TransactionsUpdateStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="ProcessorTransactionsSyncResponse defines the response schema for `/processor/transactions/sync`")
public class ProcessorTransactionsSyncResponse {
    public static final String SERIALIZED_NAME_TRANSACTIONS_UPDATE_STATUS = "transactions_update_status";
    @SerializedName(value="transactions_update_status")
    private TransactionsUpdateStatus transactionsUpdateStatus;
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private AccountBase account;
    public static final String SERIALIZED_NAME_ADDED = "added";
    @SerializedName(value="added")
    private List<Transaction> added = new ArrayList<Transaction>();
    public static final String SERIALIZED_NAME_MODIFIED = "modified";
    @SerializedName(value="modified")
    private List<Transaction> modified = new ArrayList<Transaction>();
    public static final String SERIALIZED_NAME_REMOVED = "removed";
    @SerializedName(value="removed")
    private List<RemovedTransaction> removed = new ArrayList<RemovedTransaction>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private String nextCursor;
    public static final String SERIALIZED_NAME_HAS_MORE = "has_more";
    @SerializedName(value="has_more")
    private Boolean hasMore;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public ProcessorTransactionsSyncResponse transactionsUpdateStatus(TransactionsUpdateStatus transactionsUpdateStatus) {
        this.transactionsUpdateStatus = transactionsUpdateStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransactionsUpdateStatus getTransactionsUpdateStatus() {
        return this.transactionsUpdateStatus;
    }

    public void setTransactionsUpdateStatus(TransactionsUpdateStatus transactionsUpdateStatus) {
        this.transactionsUpdateStatus = transactionsUpdateStatus;
    }

    public ProcessorTransactionsSyncResponse account(AccountBase account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public AccountBase getAccount() {
        return this.account;
    }

    public void setAccount(AccountBase account) {
        this.account = account;
    }

    public ProcessorTransactionsSyncResponse added(List<Transaction> added) {
        this.added = added;
        return this;
    }

    public ProcessorTransactionsSyncResponse addAddedItem(Transaction addedItem) {
        this.added.add(addedItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Transactions that have been added to the Item since `cursor` ordered by ascending last modified time.")
    public List<Transaction> getAdded() {
        return this.added;
    }

    public void setAdded(List<Transaction> added) {
        this.added = added;
    }

    public ProcessorTransactionsSyncResponse modified(List<Transaction> modified) {
        this.modified = modified;
        return this;
    }

    public ProcessorTransactionsSyncResponse addModifiedItem(Transaction modifiedItem) {
        this.modified.add(modifiedItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Transactions that have been modified on the Item since `cursor` ordered by ascending last modified time.")
    public List<Transaction> getModified() {
        return this.modified;
    }

    public void setModified(List<Transaction> modified) {
        this.modified = modified;
    }

    public ProcessorTransactionsSyncResponse removed(List<RemovedTransaction> removed) {
        this.removed = removed;
        return this;
    }

    public ProcessorTransactionsSyncResponse addRemovedItem(RemovedTransaction removedItem) {
        this.removed.add(removedItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Transactions that have been removed from the Item since `cursor` ordered by ascending last modified time.")
    public List<RemovedTransaction> getRemoved() {
        return this.removed;
    }

    public void setRemoved(List<RemovedTransaction> removed) {
        this.removed = removed;
    }

    public ProcessorTransactionsSyncResponse nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @ApiModelProperty(required=true, value="Cursor used for fetching any future updates after the latest update provided in this response. The cursor obtained after all pages have been pulled (indicated by `has_more` being `false`) will be valid for at least 1 year. This cursor should be persisted for later calls. If transactions are not yet available, this will be an empty string.")
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public ProcessorTransactionsSyncResponse hasMore(Boolean hasMore) {
        this.hasMore = hasMore;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents if more than requested count of transaction updates exist. If true, the additional updates can be fetched by making an additional request with `cursor` set to `next_cursor`. If `has_more` is true, it\u2019s important to pull all available pages, to make it less likely for underlying data changes to conflict with pagination.")
    public Boolean getHasMore() {
        return this.hasMore;
    }

    public void setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
    }

    public ProcessorTransactionsSyncResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessorTransactionsSyncResponse processorTransactionsSyncResponse = (ProcessorTransactionsSyncResponse)o;
        return Objects.equals((Object)this.transactionsUpdateStatus, (Object)processorTransactionsSyncResponse.transactionsUpdateStatus) && Objects.equals(this.account, processorTransactionsSyncResponse.account) && Objects.equals(this.added, processorTransactionsSyncResponse.added) && Objects.equals(this.modified, processorTransactionsSyncResponse.modified) && Objects.equals(this.removed, processorTransactionsSyncResponse.removed) && Objects.equals(this.nextCursor, processorTransactionsSyncResponse.nextCursor) && Objects.equals(this.hasMore, processorTransactionsSyncResponse.hasMore) && Objects.equals(this.requestId, processorTransactionsSyncResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionsUpdateStatus, this.account, this.added, this.modified, this.removed, this.nextCursor, this.hasMore, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProcessorTransactionsSyncResponse {\n");
        sb.append("    transactionsUpdateStatus: ").append(this.toIndentedString((Object)this.transactionsUpdateStatus)).append("\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    added: ").append(this.toIndentedString(this.added)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    removed: ").append(this.toIndentedString(this.removed)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    hasMore: ").append(this.toIndentedString(this.hasMore)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

