/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The product access being requested. Used to or disallow product access across all accounts. If unset, defaults to all products allowed.")
public class ProductAccess {
    public static final String SERIALIZED_NAME_STATEMENTS = "statements";
    @SerializedName(value="statements")
    private Boolean statements = true;
    public static final String SERIALIZED_NAME_IDENTITY = "identity";
    @SerializedName(value="identity")
    private Boolean identity = true;
    public static final String SERIALIZED_NAME_AUTH = "auth";
    @SerializedName(value="auth")
    private Boolean auth = true;
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private Boolean transactions = true;
    public static final String SERIALIZED_NAME_ACCOUNTS_DETAILS_TRANSACTIONS = "accounts_details_transactions";
    @SerializedName(value="accounts_details_transactions")
    private Boolean accountsDetailsTransactions = true;
    public static final String SERIALIZED_NAME_ACCOUNTS_ROUTING_NUMBER = "accounts_routing_number";
    @SerializedName(value="accounts_routing_number")
    private Boolean accountsRoutingNumber = true;
    public static final String SERIALIZED_NAME_ACCOUNTS_STATEMENTS = "accounts_statements";
    @SerializedName(value="accounts_statements")
    private Boolean accountsStatements = true;
    public static final String SERIALIZED_NAME_ACCOUNTS_TAX_STATEMENTS = "accounts_tax_statements";
    @SerializedName(value="accounts_tax_statements")
    private Boolean accountsTaxStatements = true;
    public static final String SERIALIZED_NAME_CUSTOMERS_PROFILES = "customers_profiles";
    @SerializedName(value="customers_profiles")
    private Boolean customersProfiles = true;

    public ProductAccess statements(Boolean statements) {
        this.statements = statements;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow access to statements. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.")
    public Boolean getStatements() {
        return this.statements;
    }

    public void setStatements(Boolean statements) {
        this.statements = statements;
    }

    public ProductAccess identity(Boolean identity) {
        this.identity = identity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow access to the Identity product (name, email, phone, address). Only used by certain partners. If relevant to the partner and unset, defaults to `true`.")
    public Boolean getIdentity() {
        return this.identity;
    }

    public void setIdentity(Boolean identity) {
        this.identity = identity;
    }

    public ProductAccess auth(Boolean auth) {
        this.auth = auth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow access to account number details. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.")
    public Boolean getAuth() {
        return this.auth;
    }

    public void setAuth(Boolean auth) {
        this.auth = auth;
    }

    public ProductAccess transactions(Boolean transactions) {
        this.transactions = transactions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow access to transaction details. Only used by certain partners. If relevant to the partner and unset, defaults to `true`.")
    public Boolean getTransactions() {
        return this.transactions;
    }

    public void setTransactions(Boolean transactions) {
        this.transactions = transactions;
    }

    public ProductAccess accountsDetailsTransactions(Boolean accountsDetailsTransactions) {
        this.accountsDetailsTransactions = accountsDetailsTransactions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow access to \"accounts_details_transactions\". Only used by certain partners. If relevant to the partner and unset, defaults to `true`.")
    public Boolean getAccountsDetailsTransactions() {
        return this.accountsDetailsTransactions;
    }

    public void setAccountsDetailsTransactions(Boolean accountsDetailsTransactions) {
        this.accountsDetailsTransactions = accountsDetailsTransactions;
    }

    public ProductAccess accountsRoutingNumber(Boolean accountsRoutingNumber) {
        this.accountsRoutingNumber = accountsRoutingNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow access to \"accounts_routing_number\". Only used by certain partners. If relevant to the partner and unset, defaults to `true`.")
    public Boolean getAccountsRoutingNumber() {
        return this.accountsRoutingNumber;
    }

    public void setAccountsRoutingNumber(Boolean accountsRoutingNumber) {
        this.accountsRoutingNumber = accountsRoutingNumber;
    }

    public ProductAccess accountsStatements(Boolean accountsStatements) {
        this.accountsStatements = accountsStatements;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow access to \"accounts_statements\". Only used by certain partners. If relevant to the partner and unset, defaults to `true`.")
    public Boolean getAccountsStatements() {
        return this.accountsStatements;
    }

    public void setAccountsStatements(Boolean accountsStatements) {
        this.accountsStatements = accountsStatements;
    }

    public ProductAccess accountsTaxStatements(Boolean accountsTaxStatements) {
        this.accountsTaxStatements = accountsTaxStatements;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow access to \"accounts_tax_statements\". Only used by certain partners. If relevant to the partner and unset, defaults to `true`.")
    public Boolean getAccountsTaxStatements() {
        return this.accountsTaxStatements;
    }

    public void setAccountsTaxStatements(Boolean accountsTaxStatements) {
        this.accountsTaxStatements = accountsTaxStatements;
    }

    public ProductAccess customersProfiles(Boolean customersProfiles) {
        this.customersProfiles = customersProfiles;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allow access to \"customers_profiles\". Only used by certain partners. If relevant to the partner and unset, defaults to `true`.")
    public Boolean getCustomersProfiles() {
        return this.customersProfiles;
    }

    public void setCustomersProfiles(Boolean customersProfiles) {
        this.customersProfiles = customersProfiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductAccess productAccess = (ProductAccess)o;
        return Objects.equals(this.statements, productAccess.statements) && Objects.equals(this.identity, productAccess.identity) && Objects.equals(this.auth, productAccess.auth) && Objects.equals(this.transactions, productAccess.transactions) && Objects.equals(this.accountsDetailsTransactions, productAccess.accountsDetailsTransactions) && Objects.equals(this.accountsRoutingNumber, productAccess.accountsRoutingNumber) && Objects.equals(this.accountsStatements, productAccess.accountsStatements) && Objects.equals(this.accountsTaxStatements, productAccess.accountsTaxStatements) && Objects.equals(this.customersProfiles, productAccess.customersProfiles);
    }

    public int hashCode() {
        return Objects.hash(this.statements, this.identity, this.auth, this.transactions, this.accountsDetailsTransactions, this.accountsRoutingNumber, this.accountsStatements, this.accountsTaxStatements, this.customersProfiles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductAccess {\n");
        sb.append("    statements: ").append(this.toIndentedString(this.statements)).append("\n");
        sb.append("    identity: ").append(this.toIndentedString(this.identity)).append("\n");
        sb.append("    auth: ").append(this.toIndentedString(this.auth)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    accountsDetailsTransactions: ").append(this.toIndentedString(this.accountsDetailsTransactions)).append("\n");
        sb.append("    accountsRoutingNumber: ").append(this.toIndentedString(this.accountsRoutingNumber)).append("\n");
        sb.append("    accountsStatements: ").append(this.toIndentedString(this.accountsStatements)).append("\n");
        sb.append("    accountsTaxStatements: ").append(this.toIndentedString(this.accountsTaxStatements)).append("\n");
        sb.append("    customersProfiles: ").append(this.toIndentedString(this.customersProfiles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

