/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.ProductStatusBreakdown;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="A representation of the status health of a request type. Auth requests, Balance requests, Identity requests, Investments requests, Liabilities requests, Transactions updates, Investments updates, Liabilities updates, and Item logins each have their own status object.")
public class ProductStatus {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_LAST_STATUS_CHANGE = "last_status_change";
    @SerializedName(value="last_status_change")
    private OffsetDateTime lastStatusChange;
    public static final String SERIALIZED_NAME_BREAKDOWN = "breakdown";
    @SerializedName(value="breakdown")
    private ProductStatusBreakdown breakdown;

    public ProductStatus status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="This field is deprecated in favor of the `breakdown` object, which provides more granular institution health data.  `HEALTHY`: the majority of requests are successful `DEGRADED`: only some requests are successful `DOWN`: all requests are failing")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ProductStatus lastStatusChange(OffsetDateTime lastStatusChange) {
        this.lastStatusChange = lastStatusChange;
        return this;
    }

    @ApiModelProperty(required=true, value="[ISO 8601](https://wikipedia.org/wiki/ISO_8601) formatted timestamp of the last status change for the institution. ")
    public OffsetDateTime getLastStatusChange() {
        return this.lastStatusChange;
    }

    public void setLastStatusChange(OffsetDateTime lastStatusChange) {
        this.lastStatusChange = lastStatusChange;
    }

    public ProductStatus breakdown(ProductStatusBreakdown breakdown) {
        this.breakdown = breakdown;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ProductStatusBreakdown getBreakdown() {
        return this.breakdown;
    }

    public void setBreakdown(ProductStatusBreakdown breakdown) {
        this.breakdown = breakdown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductStatus productStatus = (ProductStatus)o;
        return Objects.equals((Object)this.status, (Object)productStatus.status) && Objects.equals(this.lastStatusChange, productStatus.lastStatusChange) && Objects.equals(this.breakdown, productStatus.breakdown);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.lastStatusChange, this.breakdown});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductStatus {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    lastStatusChange: ").append(this.toIndentedString(this.lastStatusChange)).append("\n");
        sb.append("    breakdown: ").append(this.toIndentedString(this.breakdown)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        HEALTHY("HEALTHY"),
        DEGRADED("DEGRADED"),
        DOWN("DOWN");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

