/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A detailed breakdown of the institution's performance for a request type. The values for `success`, `error_plaid`, and `error_institution` sum to 1. The time range used for calculating the breakdown may range from the most recent few minutes to the past six hours. In general, smaller institutions will show status that was calculated over a longer period of time. For Investment updates, which are refreshed less frequently, the period assessed may be 24 hours or more. For more details, see [Institution status details](https://plaid.com/docs/account/activity/#institution-status-details).")
public class ProductStatusBreakdown {
    public static final String SERIALIZED_NAME_SUCCESS = "success";
    @SerializedName(value="success")
    private Double success;
    public static final String SERIALIZED_NAME_ERROR_PLAID = "error_plaid";
    @SerializedName(value="error_plaid")
    private Double errorPlaid;
    public static final String SERIALIZED_NAME_ERROR_INSTITUTION = "error_institution";
    @SerializedName(value="error_institution")
    private Double errorInstitution;
    public static final String SERIALIZED_NAME_REFRESH_INTERVAL = "refresh_interval";
    @SerializedName(value="refresh_interval")
    private RefreshIntervalEnum refreshInterval;

    public ProductStatusBreakdown success(Double success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(required=true, value="The percentage of login attempts that are successful, expressed as a decimal.")
    public Double getSuccess() {
        return this.success;
    }

    public void setSuccess(Double success) {
        this.success = success;
    }

    public ProductStatusBreakdown errorPlaid(Double errorPlaid) {
        this.errorPlaid = errorPlaid;
        return this;
    }

    @ApiModelProperty(required=true, value="The percentage of logins that are failing due to an internal Plaid issue, expressed as a decimal. ")
    public Double getErrorPlaid() {
        return this.errorPlaid;
    }

    public void setErrorPlaid(Double errorPlaid) {
        this.errorPlaid = errorPlaid;
    }

    public ProductStatusBreakdown errorInstitution(Double errorInstitution) {
        this.errorInstitution = errorInstitution;
        return this;
    }

    @ApiModelProperty(required=true, value="The percentage of logins that are failing due to an issue in the institution's system, expressed as a decimal.")
    public Double getErrorInstitution() {
        return this.errorInstitution;
    }

    public void setErrorInstitution(Double errorInstitution) {
        this.errorInstitution = errorInstitution;
    }

    public ProductStatusBreakdown refreshInterval(RefreshIntervalEnum refreshInterval) {
        this.refreshInterval = refreshInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `refresh_interval` may be `DELAYED` or `STOPPED` even when the success rate is high. This value is only returned for Transactions status breakdowns.")
    public RefreshIntervalEnum getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(RefreshIntervalEnum refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductStatusBreakdown productStatusBreakdown = (ProductStatusBreakdown)o;
        return Objects.equals(this.success, productStatusBreakdown.success) && Objects.equals(this.errorPlaid, productStatusBreakdown.errorPlaid) && Objects.equals(this.errorInstitution, productStatusBreakdown.errorInstitution) && Objects.equals((Object)this.refreshInterval, (Object)productStatusBreakdown.refreshInterval);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.success, this.errorPlaid, this.errorInstitution, this.refreshInterval});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProductStatusBreakdown {\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    errorPlaid: ").append(this.toIndentedString(this.errorPlaid)).append("\n");
        sb.append("    errorInstitution: ").append(this.toIndentedString(this.errorInstitution)).append("\n");
        sb.append("    refreshInterval: ").append(this.toIndentedString((Object)this.refreshInterval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RefreshIntervalEnum {
        NORMAL("NORMAL"),
        DELAYED("DELAYED"),
        STOPPED("STOPPED");

        private String value;

        private RefreshIntervalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RefreshIntervalEnum fromValue(String value) {
            for (RefreshIntervalEnum b : RefreshIntervalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RefreshIntervalEnum> {
            public void write(JsonWriter jsonWriter, RefreshIntervalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RefreshIntervalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RefreshIntervalEnum.fromValue(value);
            }
        }
    }
}

