/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ProfileGetRequest defines the request schema for `/profile/get`")
public class ProfileGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_PROFILE_TOKEN = "profile_token";
    @SerializedName(value="profile_token")
    private String profileToken;

    public ProfileGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ProfileGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public ProfileGetRequest profileToken(String profileToken) {
        this.profileToken = profileToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The profile token generated by the end user authorization session.")
    public String getProfileToken() {
        return this.profileToken;
    }

    public void setProfileToken(String profileToken) {
        this.profileToken = profileToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileGetRequest profileGetRequest = (ProfileGetRequest)o;
        return Objects.equals(this.clientId, profileGetRequest.clientId) && Objects.equals(this.secret, profileGetRequest.secret) && Objects.equals(this.profileToken, profileGetRequest.profileToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.profileToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProfileGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    profileToken: ").append(this.toIndentedString(this.profileToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

