/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ProfileItem defines an Item created during a profile authorization session.")
public class ProfileItem {
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;

    public ProfileItem itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid Item ID. The `item_id` is always unique; linking the same account at the same institution twice will result in two Items with different `item_id` values. Like all Plaid identifiers, the `item_id` is case-sensitive.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public ProfileItem accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileItem profileItem = (ProfileItem)o;
        return Objects.equals(this.itemId, profileItem.itemId) && Objects.equals(this.accessToken, profileItem.accessToken);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.accessToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProfileItem {\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

