/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The request was flagged by Plaid's fraud system, and requires additional verification to ensure they are not a bot.")
public class RecaptchaRequiredError {
    public static final String SERIALIZED_NAME_ERROR_TYPE = "error_type";
    @SerializedName(value="error_type")
    private String errorType;
    public static final String SERIALIZED_NAME_ERROR_CODE = "error_code";
    @SerializedName(value="error_code")
    private String errorCode;
    public static final String SERIALIZED_NAME_DISPLAY_MESSAGE = "display_message";
    @SerializedName(value="display_message")
    private String displayMessage;
    public static final String SERIALIZED_NAME_HTTP_CODE = "http_code";
    @SerializedName(value="http_code")
    private String httpCode;
    public static final String SERIALIZED_NAME_LINK_USER_EXPERIENCE = "link_user_experience";
    @SerializedName(value="link_user_experience")
    private String linkUserExperience;
    public static final String SERIALIZED_NAME_COMMON_CAUSES = "common_causes";
    @SerializedName(value="common_causes")
    private String commonCauses;
    public static final String SERIALIZED_NAME_TROUBLESHOOTING_STEPS = "troubleshooting_steps";
    @SerializedName(value="troubleshooting_steps")
    private String troubleshootingSteps;

    public RecaptchaRequiredError errorType(String errorType) {
        this.errorType = errorType;
        return this;
    }

    @ApiModelProperty(required=true, value="RECAPTCHA_ERROR")
    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public RecaptchaRequiredError errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(required=true, value="RECAPTCHA_REQUIRED")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public RecaptchaRequiredError displayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public void setDisplayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
    }

    public RecaptchaRequiredError httpCode(String httpCode) {
        this.httpCode = httpCode;
        return this;
    }

    @ApiModelProperty(required=true, value="400")
    public String getHttpCode() {
        return this.httpCode;
    }

    public void setHttpCode(String httpCode) {
        this.httpCode = httpCode;
    }

    public RecaptchaRequiredError linkUserExperience(String linkUserExperience) {
        this.linkUserExperience = linkUserExperience;
        return this;
    }

    @ApiModelProperty(required=true, value="Your user will be prompted to solve a Google reCAPTCHA challenge in the Link Recaptcha pane. If they solve the challenge successfully, the user's request is resubmitted and they are directed to the next Item creation step.")
    public String getLinkUserExperience() {
        return this.linkUserExperience;
    }

    public void setLinkUserExperience(String linkUserExperience) {
        this.linkUserExperience = linkUserExperience;
    }

    public RecaptchaRequiredError commonCauses(String commonCauses) {
        this.commonCauses = commonCauses;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid's fraud system detects abusive traffic and considers a variety of parameters throughout Item creation requests. When a request is considered risky or possibly fraudulent, Link presents a reCAPTCHA for the user to solve.")
    public String getCommonCauses() {
        return this.commonCauses;
    }

    public void setCommonCauses(String commonCauses) {
        this.commonCauses = commonCauses;
    }

    public RecaptchaRequiredError troubleshootingSteps(String troubleshootingSteps) {
        this.troubleshootingSteps = troubleshootingSteps;
        return this;
    }

    @ApiModelProperty(required=true, value="Link will automatically guide your user through reCAPTCHA verification. As a general rule, we recommend instrumenting basic fraud monitoring to detect and protect your website from spam and abuse.  If your user cannot verify their session, please submit a Support ticket with the following identifiers: `link_session_id` or `request_id`")
    public String getTroubleshootingSteps() {
        return this.troubleshootingSteps;
    }

    public void setTroubleshootingSteps(String troubleshootingSteps) {
        this.troubleshootingSteps = troubleshootingSteps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecaptchaRequiredError recaptchaRequiredError = (RecaptchaRequiredError)o;
        return Objects.equals(this.errorType, recaptchaRequiredError.errorType) && Objects.equals(this.errorCode, recaptchaRequiredError.errorCode) && Objects.equals(this.displayMessage, recaptchaRequiredError.displayMessage) && Objects.equals(this.httpCode, recaptchaRequiredError.httpCode) && Objects.equals(this.linkUserExperience, recaptchaRequiredError.linkUserExperience) && Objects.equals(this.commonCauses, recaptchaRequiredError.commonCauses) && Objects.equals(this.troubleshootingSteps, recaptchaRequiredError.troubleshootingSteps);
    }

    public int hashCode() {
        return Objects.hash(this.errorType, this.errorCode, this.displayMessage, this.httpCode, this.linkUserExperience, this.commonCauses, this.troubleshootingSteps);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecaptchaRequiredError {\n");
        sb.append("    errorType: ").append(this.toIndentedString(this.errorType)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    displayMessage: ").append(this.toIndentedString(this.displayMessage)).append("\n");
        sb.append("    httpCode: ").append(this.toIndentedString(this.httpCode)).append("\n");
        sb.append("    linkUserExperience: ").append(this.toIndentedString(this.linkUserExperience)).append("\n");
        sb.append("    commonCauses: ").append(this.toIndentedString(this.commonCauses)).append("\n");
        sb.append("    troubleshootingSteps: ").append(this.toIndentedString(this.troubleshootingSteps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

