/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing a BACS account number and sort code. If an IBAN is not provided or if this recipient needs to accept domestic GBP-denominated payments, BACS data is required.")
public class RecipientBACSNullable {
    public static final String SERIALIZED_NAME_ACCOUNT = "account";
    @SerializedName(value="account")
    private String account;
    public static final String SERIALIZED_NAME_SORT_CODE = "sort_code";
    @SerializedName(value="sort_code")
    private String sortCode;

    public RecipientBACSNullable account(String account) {
        this.account = account;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account number of the account. Maximum of 10 characters.")
    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public RecipientBACSNullable sortCode(String sortCode) {
        this.sortCode = sortCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The 6-character sort code of the account.")
    public String getSortCode() {
        return this.sortCode;
    }

    public void setSortCode(String sortCode) {
        this.sortCode = sortCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipientBACSNullable recipientBACSNullable = (RecipientBACSNullable)o;
        return Objects.equals(this.account, recipientBACSNullable.account) && Objects.equals(this.sortCode, recipientBACSNullable.sortCode);
    }

    public int hashCode() {
        return Objects.hash(this.account, this.sortCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecipientBACSNullable {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    sortCode: ").append(this.toIndentedString(this.sortCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

