/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.RecurringTransactionFrequency;
import com.plaid.client.model.TransactionStreamAmount;
import com.plaid.client.model.TransactionStreamStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Insights object for recurring transactions streams.")
public class RecurringInsightsStream {
    public static final String SERIALIZED_NAME_STREAM_ID = "stream_id";
    @SerializedName(value="stream_id")
    private String streamId;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchant_name";
    @SerializedName(value="merchant_name")
    private String merchantName;
    public static final String SERIALIZED_NAME_OLDEST_TRANSACTION_DATE = "oldest_transaction_date";
    @SerializedName(value="oldest_transaction_date")
    private LocalDate oldestTransactionDate;
    public static final String SERIALIZED_NAME_NEWEST_TRANSACTION_DATE = "newest_transaction_date";
    @SerializedName(value="newest_transaction_date")
    private LocalDate newestTransactionDate;
    public static final String SERIALIZED_NAME_AVERAGE_DAYS_APART = "average_days_apart";
    @SerializedName(value="average_days_apart")
    private Double averageDaysApart;
    public static final String SERIALIZED_NAME_FREQUENCY = "frequency";
    @SerializedName(value="frequency")
    private RecurringTransactionFrequency frequency;
    public static final String SERIALIZED_NAME_TRANSACTION_COUNT = "transaction_count";
    @SerializedName(value="transaction_count")
    private Integer transactionCount;
    public static final String SERIALIZED_NAME_TRANSACTION_IDS = "transaction_ids";
    @SerializedName(value="transaction_ids")
    private List<String> transactionIds = null;
    public static final String SERIALIZED_NAME_AVERAGE_AMOUNT = "average_amount";
    @SerializedName(value="average_amount")
    private TransactionStreamAmount averageAmount;
    public static final String SERIALIZED_NAME_NEWEST_TRANSACTION_AMOUNT = "newest_transaction_amount";
    @SerializedName(value="newest_transaction_amount")
    private TransactionStreamAmount newestTransactionAmount;
    public static final String SERIALIZED_NAME_IS_ACTIVE = "is_active";
    @SerializedName(value="is_active")
    private Boolean isActive;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TransactionStreamStatus status;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY_PRIMARY = "personal_finance_category_primary";
    @SerializedName(value="personal_finance_category_primary")
    private String personalFinanceCategoryPrimary;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY_DETAILED = "personal_finance_category_detailed";
    @SerializedName(value="personal_finance_category_detailed")
    private String personalFinanceCategoryDetailed;

    public RecurringInsightsStream streamId(String streamId) {
        this.streamId = streamId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique id for the stream.")
    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public RecurringInsightsStream description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The client-provided raw description of the most recent transaction in the stream.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RecurringInsightsStream merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant or primary counterparty associated with the transaction stream.")
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public RecurringInsightsStream oldestTransactionDate(LocalDate oldestTransactionDate) {
        this.oldestTransactionDate = oldestTransactionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The posted date of the earliest transaction in the stream.")
    public LocalDate getOldestTransactionDate() {
        return this.oldestTransactionDate;
    }

    public void setOldestTransactionDate(LocalDate oldestTransactionDate) {
        this.oldestTransactionDate = oldestTransactionDate;
    }

    public RecurringInsightsStream newestTransactionDate(LocalDate newestTransactionDate) {
        this.newestTransactionDate = newestTransactionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The posted date of the latest transaction in the stream.")
    public LocalDate getNewestTransactionDate() {
        return this.newestTransactionDate;
    }

    public void setNewestTransactionDate(LocalDate newestTransactionDate) {
        this.newestTransactionDate = newestTransactionDate;
    }

    public RecurringInsightsStream averageDaysApart(Double averageDaysApart) {
        this.averageDaysApart = averageDaysApart;
        return this;
    }

    @ApiModelProperty(required=true, value="The average number of days between each of the recurring transactions.")
    public Double getAverageDaysApart() {
        return this.averageDaysApart;
    }

    public void setAverageDaysApart(Double averageDaysApart) {
        this.averageDaysApart = averageDaysApart;
    }

    public RecurringInsightsStream frequency(RecurringTransactionFrequency frequency) {
        this.frequency = frequency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public RecurringTransactionFrequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(RecurringTransactionFrequency frequency) {
        this.frequency = frequency;
    }

    public RecurringInsightsStream transactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of transactions in this stream.")
    public Integer getTransactionCount() {
        return this.transactionCount;
    }

    public void setTransactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
    }

    public RecurringInsightsStream transactionIds(List<String> transactionIds) {
        this.transactionIds = transactionIds;
        return this;
    }

    public RecurringInsightsStream addTransactionIdsItem(String transactionIdsItem) {
        if (this.transactionIds == null) {
            this.transactionIds = new ArrayList<String>();
        }
        this.transactionIds.add(transactionIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of Plaid transaction IDs belonging to the stream, sorted by posted date.")
    public List<String> getTransactionIds() {
        return this.transactionIds;
    }

    public void setTransactionIds(List<String> transactionIds) {
        this.transactionIds = transactionIds;
    }

    public RecurringInsightsStream averageAmount(TransactionStreamAmount averageAmount) {
        this.averageAmount = averageAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransactionStreamAmount getAverageAmount() {
        return this.averageAmount;
    }

    public void setAverageAmount(TransactionStreamAmount averageAmount) {
        this.averageAmount = averageAmount;
    }

    public RecurringInsightsStream newestTransactionAmount(TransactionStreamAmount newestTransactionAmount) {
        this.newestTransactionAmount = newestTransactionAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransactionStreamAmount getNewestTransactionAmount() {
        return this.newestTransactionAmount;
    }

    public void setNewestTransactionAmount(TransactionStreamAmount newestTransactionAmount) {
        this.newestTransactionAmount = newestTransactionAmount;
    }

    public RecurringInsightsStream isActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates whether the transaction stream is still live.")
    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public RecurringInsightsStream status(TransactionStreamStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransactionStreamStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransactionStreamStatus status) {
        this.status = status;
    }

    public RecurringInsightsStream personalFinanceCategoryPrimary(String personalFinanceCategoryPrimary) {
        this.personalFinanceCategoryPrimary = personalFinanceCategoryPrimary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The primary category associated with the transaction stream.")
    public String getPersonalFinanceCategoryPrimary() {
        return this.personalFinanceCategoryPrimary;
    }

    public void setPersonalFinanceCategoryPrimary(String personalFinanceCategoryPrimary) {
        this.personalFinanceCategoryPrimary = personalFinanceCategoryPrimary;
    }

    public RecurringInsightsStream personalFinanceCategoryDetailed(String personalFinanceCategoryDetailed) {
        this.personalFinanceCategoryDetailed = personalFinanceCategoryDetailed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The detailed category associated with the transaction stream.")
    public String getPersonalFinanceCategoryDetailed() {
        return this.personalFinanceCategoryDetailed;
    }

    public void setPersonalFinanceCategoryDetailed(String personalFinanceCategoryDetailed) {
        this.personalFinanceCategoryDetailed = personalFinanceCategoryDetailed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringInsightsStream recurringInsightsStream = (RecurringInsightsStream)o;
        return Objects.equals(this.streamId, recurringInsightsStream.streamId) && Objects.equals(this.description, recurringInsightsStream.description) && Objects.equals(this.merchantName, recurringInsightsStream.merchantName) && Objects.equals(this.oldestTransactionDate, recurringInsightsStream.oldestTransactionDate) && Objects.equals(this.newestTransactionDate, recurringInsightsStream.newestTransactionDate) && Objects.equals(this.averageDaysApart, recurringInsightsStream.averageDaysApart) && Objects.equals((Object)this.frequency, (Object)recurringInsightsStream.frequency) && Objects.equals(this.transactionCount, recurringInsightsStream.transactionCount) && Objects.equals(this.transactionIds, recurringInsightsStream.transactionIds) && Objects.equals(this.averageAmount, recurringInsightsStream.averageAmount) && Objects.equals(this.newestTransactionAmount, recurringInsightsStream.newestTransactionAmount) && Objects.equals(this.isActive, recurringInsightsStream.isActive) && Objects.equals((Object)this.status, (Object)recurringInsightsStream.status) && Objects.equals(this.personalFinanceCategoryPrimary, recurringInsightsStream.personalFinanceCategoryPrimary) && Objects.equals(this.personalFinanceCategoryDetailed, recurringInsightsStream.personalFinanceCategoryDetailed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.streamId, this.description, this.merchantName, this.oldestTransactionDate, this.newestTransactionDate, this.averageDaysApart, this.frequency, this.transactionCount, this.transactionIds, this.averageAmount, this.newestTransactionAmount, this.isActive, this.status, this.personalFinanceCategoryPrimary, this.personalFinanceCategoryDetailed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurringInsightsStream {\n");
        sb.append("    streamId: ").append(this.toIndentedString(this.streamId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    oldestTransactionDate: ").append(this.toIndentedString(this.oldestTransactionDate)).append("\n");
        sb.append("    newestTransactionDate: ").append(this.toIndentedString(this.newestTransactionDate)).append("\n");
        sb.append("    averageDaysApart: ").append(this.toIndentedString(this.averageDaysApart)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString((Object)this.frequency)).append("\n");
        sb.append("    transactionCount: ").append(this.toIndentedString(this.transactionCount)).append("\n");
        sb.append("    transactionIds: ").append(this.toIndentedString(this.transactionIds)).append("\n");
        sb.append("    averageAmount: ").append(this.toIndentedString(this.averageAmount)).append("\n");
        sb.append("    newestTransactionAmount: ").append(this.toIndentedString(this.newestTransactionAmount)).append("\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    personalFinanceCategoryPrimary: ").append(this.toIndentedString(this.personalFinanceCategoryPrimary)).append("\n");
        sb.append("    personalFinanceCategoryDetailed: ").append(this.toIndentedString(this.personalFinanceCategoryDetailed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

