/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Fired when a new transfer of a recurring transfer is originated.")
public class RecurringNewTransferWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_RECURRING_TRANSFER_ID = "recurring_transfer_id";
    @SerializedName(value="recurring_transfer_id")
    private String recurringTransferId;
    public static final String SERIALIZED_NAME_TRANSFER_ID = "transfer_id";
    @SerializedName(value="transfer_id")
    private String transferId;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public RecurringNewTransferWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`TRANSFER`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public RecurringNewTransferWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`RECURRING_NEW_TRANSFER`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public RecurringNewTransferWebhook recurringTransferId(String recurringTransferId) {
        this.recurringTransferId = recurringTransferId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a recurring transfer.")
    public String getRecurringTransferId() {
        return this.recurringTransferId;
    }

    public void setRecurringTransferId(String recurringTransferId) {
        this.recurringTransferId = recurringTransferId;
    }

    public RecurringNewTransferWebhook transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a transfer.")
    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public RecurringNewTransferWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringNewTransferWebhook recurringNewTransferWebhook = (RecurringNewTransferWebhook)o;
        return Objects.equals(this.webhookType, recurringNewTransferWebhook.webhookType) && Objects.equals(this.webhookCode, recurringNewTransferWebhook.webhookCode) && Objects.equals(this.recurringTransferId, recurringNewTransferWebhook.recurringTransferId) && Objects.equals(this.transferId, recurringNewTransferWebhook.transferId) && Objects.equals((Object)this.environment, (Object)recurringNewTransferWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.recurringTransferId, this.transferId, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurringNewTransferWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    recurringTransferId: ").append(this.toIndentedString(this.recurringTransferId)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

