/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.RecurringInsightsStream;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Insights object for recurring transactions for `/beta/transactions/user_insights/v1/get` endpoint")
public class RecurringTransactions {
    public static final String SERIALIZED_NAME_INFLOW_STREAMS = "inflow_streams";
    @SerializedName(value="inflow_streams")
    private List<RecurringInsightsStream> inflowStreams = new ArrayList<RecurringInsightsStream>();
    public static final String SERIALIZED_NAME_OUTFLOW_STREAMS = "outflow_streams";
    @SerializedName(value="outflow_streams")
    private List<RecurringInsightsStream> outflowStreams = new ArrayList<RecurringInsightsStream>();

    public RecurringTransactions inflowStreams(List<RecurringInsightsStream> inflowStreams) {
        this.inflowStreams = inflowStreams;
        return this;
    }

    public RecurringTransactions addInflowStreamsItem(RecurringInsightsStream inflowStreamsItem) {
        this.inflowStreams.add(inflowStreamsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of inflow transaction streams (e.g., income).")
    public List<RecurringInsightsStream> getInflowStreams() {
        return this.inflowStreams;
    }

    public void setInflowStreams(List<RecurringInsightsStream> inflowStreams) {
        this.inflowStreams = inflowStreams;
    }

    public RecurringTransactions outflowStreams(List<RecurringInsightsStream> outflowStreams) {
        this.outflowStreams = outflowStreams;
        return this;
    }

    public RecurringTransactions addOutflowStreamsItem(RecurringInsightsStream outflowStreamsItem) {
        this.outflowStreams.add(outflowStreamsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of outflow transaction streams (e.g., subscriptions, bills, loan payments).")
    public List<RecurringInsightsStream> getOutflowStreams() {
        return this.outflowStreams;
    }

    public void setOutflowStreams(List<RecurringInsightsStream> outflowStreams) {
        this.outflowStreams = outflowStreams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringTransactions recurringTransactions = (RecurringTransactions)o;
        return Objects.equals(this.inflowStreams, recurringTransactions.inflowStreams) && Objects.equals(this.outflowStreams, recurringTransactions.outflowStreams);
    }

    public int hashCode() {
        return Objects.hash(this.inflowStreams, this.outflowStreams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurringTransactions {\n");
        sb.append("    inflowStreams: ").append(this.toIndentedString(this.inflowStreams)).append("\n");
        sb.append("    outflowStreams: ").append(this.toIndentedString(this.outflowStreams)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

