/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.TransferRecurringNetwork;
import com.plaid.client.model.TransferRecurringSchedule;
import com.plaid.client.model.TransferRecurringStatus;
import com.plaid.client.model.TransferType;
import com.plaid.client.model.TransferUserInResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a recurring transfer within the Transfers API.")
public class RecurringTransfer {
    public static final String SERIALIZED_NAME_RECURRING_TRANSFER_ID = "recurring_transfer_id";
    @SerializedName(value="recurring_transfer_id")
    private String recurringTransferId;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_NEXT_ORIGINATION_DATE = "next_origination_date";
    @SerializedName(value="next_origination_date")
    private LocalDate nextOriginationDate;
    public static final String SERIALIZED_NAME_TEST_CLOCK_ID = "test_clock_id";
    @SerializedName(value="test_clock_id")
    private String testClockId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TransferType type;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TransferRecurringStatus status;
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private TransferRecurringNetwork network;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_TRANSFER_IDS = "transfer_ids";
    @SerializedName(value="transfer_ids")
    private List<String> transferIds = new ArrayList<String>();
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private TransferUserInResponse user;
    public static final String SERIALIZED_NAME_SCHEDULE = "schedule";
    @SerializedName(value="schedule")
    private TransferRecurringSchedule schedule;

    public RecurringTransfer recurringTransferId(String recurringTransferId) {
        this.recurringTransferId = recurringTransferId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a recurring transfer.")
    public String getRecurringTransferId() {
        return this.recurringTransferId;
    }

    public void setRecurringTransferId(String recurringTransferId) {
        this.recurringTransferId = recurringTransferId;
    }

    public RecurringTransfer created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime when this transfer was created. This will be of the form `2006-01-02T15:04:05Z`")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public RecurringTransfer nextOriginationDate(LocalDate nextOriginationDate) {
        this.nextOriginationDate = nextOriginationDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD).  The next transfer origination date after bank holiday adjustment.")
    public LocalDate getNextOriginationDate() {
        return this.nextOriginationDate;
    }

    public void setNextOriginationDate(LocalDate nextOriginationDate) {
        this.nextOriginationDate = nextOriginationDate;
    }

    public RecurringTransfer testClockId(String testClockId) {
        this.testClockId = testClockId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for a test clock.")
    public String getTestClockId() {
        return this.testClockId;
    }

    public void setTestClockId(String testClockId) {
        this.testClockId = testClockId;
    }

    public RecurringTransfer type(TransferType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferType getType() {
        return this.type;
    }

    public void setType(TransferType type) {
        this.type = type;
    }

    public RecurringTransfer amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\"). When calling `/transfer/authorization/create`, specify the maximum amount to authorize. When calling `/transfer/create`, specify the exact amount of the transfer, up to a maximum of the amount authorized. If this field is left blank when calling `/transfer/create`, the maximum amount authorized in the `authorization_id` will be sent.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public RecurringTransfer status(TransferRecurringStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferRecurringStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransferRecurringStatus status) {
        this.status = status;
    }

    public RecurringTransfer achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public RecurringTransfer network(TransferRecurringNetwork network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferRecurringNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(TransferRecurringNetwork network) {
        this.network = network;
    }

    public RecurringTransfer originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for the origination account that was used for this transfer.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public RecurringTransfer accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `account_id` corresponding to the end-user account that will be debited or credited.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public RecurringTransfer fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of the funding account to use, available in the Plaid Dashboard. This determines which of your business checking accounts will be credited or debited.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public RecurringTransfer isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the transfer amount, e.g. \"USD\"")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public RecurringTransfer description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the recurring transfer.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RecurringTransfer transferIds(List<String> transferIds) {
        this.transferIds = transferIds;
        return this;
    }

    public RecurringTransfer addTransferIdsItem(String transferIdsItem) {
        this.transferIds.add(transferIdsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<String> getTransferIds() {
        return this.transferIds;
    }

    public void setTransferIds(List<String> transferIds) {
        this.transferIds = transferIds;
    }

    public RecurringTransfer user(TransferUserInResponse user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferUserInResponse getUser() {
        return this.user;
    }

    public void setUser(TransferUserInResponse user) {
        this.user = user;
    }

    public RecurringTransfer schedule(TransferRecurringSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferRecurringSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(TransferRecurringSchedule schedule) {
        this.schedule = schedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringTransfer recurringTransfer = (RecurringTransfer)o;
        return Objects.equals(this.recurringTransferId, recurringTransfer.recurringTransferId) && Objects.equals(this.created, recurringTransfer.created) && Objects.equals(this.nextOriginationDate, recurringTransfer.nextOriginationDate) && Objects.equals(this.testClockId, recurringTransfer.testClockId) && Objects.equals((Object)this.type, (Object)recurringTransfer.type) && Objects.equals(this.amount, recurringTransfer.amount) && Objects.equals((Object)this.status, (Object)recurringTransfer.status) && Objects.equals((Object)this.achClass, (Object)recurringTransfer.achClass) && Objects.equals((Object)this.network, (Object)recurringTransfer.network) && Objects.equals(this.originationAccountId, recurringTransfer.originationAccountId) && Objects.equals(this.accountId, recurringTransfer.accountId) && Objects.equals(this.fundingAccountId, recurringTransfer.fundingAccountId) && Objects.equals(this.isoCurrencyCode, recurringTransfer.isoCurrencyCode) && Objects.equals(this.description, recurringTransfer.description) && Objects.equals(this.transferIds, recurringTransfer.transferIds) && Objects.equals(this.user, recurringTransfer.user) && Objects.equals(this.schedule, recurringTransfer.schedule);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.recurringTransferId, this.created, this.nextOriginationDate, this.testClockId, this.type, this.amount, this.status, this.achClass, this.network, this.originationAccountId, this.accountId, this.fundingAccountId, this.isoCurrencyCode, this.description, this.transferIds, this.user, this.schedule});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurringTransfer {\n");
        sb.append("    recurringTransferId: ").append(this.toIndentedString(this.recurringTransferId)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    nextOriginationDate: ").append(this.toIndentedString(this.nextOriginationDate)).append("\n");
        sb.append("    testClockId: ").append(this.toIndentedString(this.testClockId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    transferIds: ").append(this.toIndentedString(this.transferIds)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

