/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferAuthorizationDecision;
import com.plaid.client.model.TransferAuthorizationDecisionRationaleCode;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when Plaid is unable to originate a new ACH transaction of the recurring transfer on the planned date.")
public class RecurringTransferSkippedWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_RECURRING_TRANSFER_ID = "recurring_transfer_id";
    @SerializedName(value="recurring_transfer_id")
    private String recurringTransferId;
    public static final String SERIALIZED_NAME_AUTHORIZATION_DECISION = "authorization_decision";
    @SerializedName(value="authorization_decision")
    private TransferAuthorizationDecision authorizationDecision;
    public static final String SERIALIZED_NAME_AUTHORIZATION_DECISION_RATIONALE_CODE = "authorization_decision_rationale_code";
    @SerializedName(value="authorization_decision_rationale_code")
    private TransferAuthorizationDecisionRationaleCode authorizationDecisionRationaleCode;
    public static final String SERIALIZED_NAME_SKIPPED_ORIGINATION_DATE = "skipped_origination_date";
    @SerializedName(value="skipped_origination_date")
    private LocalDate skippedOriginationDate;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public RecurringTransferSkippedWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`TRANSFER`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public RecurringTransferSkippedWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`RECURRING_TRANSFER_SKIPPED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public RecurringTransferSkippedWebhook recurringTransferId(String recurringTransferId) {
        this.recurringTransferId = recurringTransferId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a recurring transfer.")
    public String getRecurringTransferId() {
        return this.recurringTransferId;
    }

    public void setRecurringTransferId(String recurringTransferId) {
        this.recurringTransferId = recurringTransferId;
    }

    public RecurringTransferSkippedWebhook authorizationDecision(TransferAuthorizationDecision authorizationDecision) {
        this.authorizationDecision = authorizationDecision;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationDecision getAuthorizationDecision() {
        return this.authorizationDecision;
    }

    public void setAuthorizationDecision(TransferAuthorizationDecision authorizationDecision) {
        this.authorizationDecision = authorizationDecision;
    }

    public RecurringTransferSkippedWebhook authorizationDecisionRationaleCode(TransferAuthorizationDecisionRationaleCode authorizationDecisionRationaleCode) {
        this.authorizationDecisionRationaleCode = authorizationDecisionRationaleCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferAuthorizationDecisionRationaleCode getAuthorizationDecisionRationaleCode() {
        return this.authorizationDecisionRationaleCode;
    }

    public void setAuthorizationDecisionRationaleCode(TransferAuthorizationDecisionRationaleCode authorizationDecisionRationaleCode) {
        this.authorizationDecisionRationaleCode = authorizationDecisionRationaleCode;
    }

    public RecurringTransferSkippedWebhook skippedOriginationDate(LocalDate skippedOriginationDate) {
        this.skippedOriginationDate = skippedOriginationDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The planned date on which Plaid is unable to originate a new ACH transaction of the recurring transfer. This will be of the form YYYY-MM-DD.")
    public LocalDate getSkippedOriginationDate() {
        return this.skippedOriginationDate;
    }

    public void setSkippedOriginationDate(LocalDate skippedOriginationDate) {
        this.skippedOriginationDate = skippedOriginationDate;
    }

    public RecurringTransferSkippedWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringTransferSkippedWebhook recurringTransferSkippedWebhook = (RecurringTransferSkippedWebhook)o;
        return Objects.equals(this.webhookType, recurringTransferSkippedWebhook.webhookType) && Objects.equals(this.webhookCode, recurringTransferSkippedWebhook.webhookCode) && Objects.equals(this.recurringTransferId, recurringTransferSkippedWebhook.recurringTransferId) && Objects.equals((Object)this.authorizationDecision, (Object)recurringTransferSkippedWebhook.authorizationDecision) && Objects.equals((Object)this.authorizationDecisionRationaleCode, (Object)recurringTransferSkippedWebhook.authorizationDecisionRationaleCode) && Objects.equals(this.skippedOriginationDate, recurringTransferSkippedWebhook.skippedOriginationDate) && Objects.equals((Object)this.environment, (Object)recurringTransferSkippedWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.recurringTransferId, this.authorizationDecision, this.authorizationDecisionRationaleCode, this.skippedOriginationDate, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurringTransferSkippedWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    recurringTransferId: ").append(this.toIndentedString(this.recurringTransferId)).append("\n");
        sb.append("    authorizationDecision: ").append(this.toIndentedString((Object)this.authorizationDecision)).append("\n");
        sb.append("    authorizationDecisionRationaleCode: ").append(this.toIndentedString((Object)this.authorizationDecisionRationaleCode)).append("\n");
        sb.append("    skippedOriginationDate: ").append(this.toIndentedString(this.skippedOriginationDate)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

