/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ProxyType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result summary object specifying values for `device` attributes of risk check.")
public class RiskCheckDevice {
    public static final String SERIALIZED_NAME_IP_PROXY_TYPE = "ip_proxy_type";
    @SerializedName(value="ip_proxy_type")
    private ProxyType ipProxyType;
    public static final String SERIALIZED_NAME_IP_SPAM_LIST_COUNT = "ip_spam_list_count";
    @SerializedName(value="ip_spam_list_count")
    private Integer ipSpamListCount;
    public static final String SERIALIZED_NAME_IP_TIMEZONE_OFFSET = "ip_timezone_offset";
    @SerializedName(value="ip_timezone_offset")
    private String ipTimezoneOffset;

    public RiskCheckDevice ipProxyType(ProxyType ipProxyType) {
        this.ipProxyType = ipProxyType;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public ProxyType getIpProxyType() {
        return this.ipProxyType;
    }

    public void setIpProxyType(ProxyType ipProxyType) {
        this.ipProxyType = ipProxyType;
    }

    public RiskCheckDevice ipSpamListCount(Integer ipSpamListCount) {
        this.ipSpamListCount = ipSpamListCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", required=true, value="Count of spam lists the IP address is associated with if known.")
    public Integer getIpSpamListCount() {
        return this.ipSpamListCount;
    }

    public void setIpSpamListCount(Integer ipSpamListCount) {
        this.ipSpamListCount = ipSpamListCount;
    }

    public RiskCheckDevice ipTimezoneOffset(String ipTimezoneOffset) {
        this.ipTimezoneOffset = ipTimezoneOffset;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="+06:00:00", required=true, value="UTC offset of the timezone associated with the IP address.")
    public String getIpTimezoneOffset() {
        return this.ipTimezoneOffset;
    }

    public void setIpTimezoneOffset(String ipTimezoneOffset) {
        this.ipTimezoneOffset = ipTimezoneOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiskCheckDevice riskCheckDevice = (RiskCheckDevice)o;
        return Objects.equals((Object)this.ipProxyType, (Object)riskCheckDevice.ipProxyType) && Objects.equals(this.ipSpamListCount, riskCheckDevice.ipSpamListCount) && Objects.equals(this.ipTimezoneOffset, riskCheckDevice.ipTimezoneOffset);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ipProxyType, this.ipSpamListCount, this.ipTimezoneOffset});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiskCheckDevice {\n");
        sb.append("    ipProxyType: ").append(this.toIndentedString((Object)this.ipProxyType)).append("\n");
        sb.append("    ipSpamListCount: ").append(this.toIndentedString(this.ipSpamListCount)).append("\n");
        sb.append("    ipTimezoneOffset: ").append(this.toIndentedString(this.ipTimezoneOffset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

