/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.RiskCheckEmailDomainIsCustom;
import com.plaid.client.model.RiskCheckEmailDomainIsDisposable;
import com.plaid.client.model.RiskCheckEmailDomainIsFreeProvider;
import com.plaid.client.model.RiskCheckEmailIsDeliverableStatus;
import com.plaid.client.model.RiskCheckEmailTopLevelDomainIsSuspicious;
import com.plaid.client.model.RiskCheckLinkedService;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="Result summary object specifying values for `email` attributes of risk check.")
public class RiskCheckEmail {
    public static final String SERIALIZED_NAME_IS_DELIVERABLE = "is_deliverable";
    @SerializedName(value="is_deliverable")
    private RiskCheckEmailIsDeliverableStatus isDeliverable;
    public static final String SERIALIZED_NAME_BREACH_COUNT = "breach_count";
    @SerializedName(value="breach_count")
    private Integer breachCount;
    public static final String SERIALIZED_NAME_FIRST_BREACHED_AT = "first_breached_at";
    @SerializedName(value="first_breached_at")
    private LocalDate firstBreachedAt;
    public static final String SERIALIZED_NAME_LAST_BREACHED_AT = "last_breached_at";
    @SerializedName(value="last_breached_at")
    private LocalDate lastBreachedAt;
    public static final String SERIALIZED_NAME_DOMAIN_REGISTERED_AT = "domain_registered_at";
    @SerializedName(value="domain_registered_at")
    private LocalDate domainRegisteredAt;
    public static final String SERIALIZED_NAME_DOMAIN_IS_FREE_PROVIDER = "domain_is_free_provider";
    @SerializedName(value="domain_is_free_provider")
    private RiskCheckEmailDomainIsFreeProvider domainIsFreeProvider;
    public static final String SERIALIZED_NAME_DOMAIN_IS_CUSTOM = "domain_is_custom";
    @SerializedName(value="domain_is_custom")
    private RiskCheckEmailDomainIsCustom domainIsCustom;
    public static final String SERIALIZED_NAME_DOMAIN_IS_DISPOSABLE = "domain_is_disposable";
    @SerializedName(value="domain_is_disposable")
    private RiskCheckEmailDomainIsDisposable domainIsDisposable;
    public static final String SERIALIZED_NAME_TOP_LEVEL_DOMAIN_IS_SUSPICIOUS = "top_level_domain_is_suspicious";
    @SerializedName(value="top_level_domain_is_suspicious")
    private RiskCheckEmailTopLevelDomainIsSuspicious topLevelDomainIsSuspicious;
    public static final String SERIALIZED_NAME_LINKED_SERVICES = "linked_services";
    @SerializedName(value="linked_services")
    private Set<RiskCheckLinkedService> linkedServices = new LinkedHashSet<RiskCheckLinkedService>();

    public RiskCheckEmail isDeliverable(RiskCheckEmailIsDeliverableStatus isDeliverable) {
        this.isDeliverable = isDeliverable;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public RiskCheckEmailIsDeliverableStatus getIsDeliverable() {
        return this.isDeliverable;
    }

    public void setIsDeliverable(RiskCheckEmailIsDeliverableStatus isDeliverable) {
        this.isDeliverable = isDeliverable;
    }

    public RiskCheckEmail breachCount(Integer breachCount) {
        this.breachCount = breachCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", required=true, value="Count of all known breaches of this email address if known.")
    public Integer getBreachCount() {
        return this.breachCount;
    }

    public void setBreachCount(Integer breachCount) {
        this.breachCount = breachCount;
    }

    public RiskCheckEmail firstBreachedAt(LocalDate firstBreachedAt) {
        this.firstBreachedAt = firstBreachedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getFirstBreachedAt() {
        return this.firstBreachedAt;
    }

    public void setFirstBreachedAt(LocalDate firstBreachedAt) {
        this.firstBreachedAt = firstBreachedAt;
    }

    public RiskCheckEmail lastBreachedAt(LocalDate lastBreachedAt) {
        this.lastBreachedAt = lastBreachedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getLastBreachedAt() {
        return this.lastBreachedAt;
    }

    public void setLastBreachedAt(LocalDate lastBreachedAt) {
        this.lastBreachedAt = lastBreachedAt;
    }

    public RiskCheckEmail domainRegisteredAt(LocalDate domainRegisteredAt) {
        this.domainRegisteredAt = domainRegisteredAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getDomainRegisteredAt() {
        return this.domainRegisteredAt;
    }

    public void setDomainRegisteredAt(LocalDate domainRegisteredAt) {
        this.domainRegisteredAt = domainRegisteredAt;
    }

    public RiskCheckEmail domainIsFreeProvider(RiskCheckEmailDomainIsFreeProvider domainIsFreeProvider) {
        this.domainIsFreeProvider = domainIsFreeProvider;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public RiskCheckEmailDomainIsFreeProvider getDomainIsFreeProvider() {
        return this.domainIsFreeProvider;
    }

    public void setDomainIsFreeProvider(RiskCheckEmailDomainIsFreeProvider domainIsFreeProvider) {
        this.domainIsFreeProvider = domainIsFreeProvider;
    }

    public RiskCheckEmail domainIsCustom(RiskCheckEmailDomainIsCustom domainIsCustom) {
        this.domainIsCustom = domainIsCustom;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public RiskCheckEmailDomainIsCustom getDomainIsCustom() {
        return this.domainIsCustom;
    }

    public void setDomainIsCustom(RiskCheckEmailDomainIsCustom domainIsCustom) {
        this.domainIsCustom = domainIsCustom;
    }

    public RiskCheckEmail domainIsDisposable(RiskCheckEmailDomainIsDisposable domainIsDisposable) {
        this.domainIsDisposable = domainIsDisposable;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public RiskCheckEmailDomainIsDisposable getDomainIsDisposable() {
        return this.domainIsDisposable;
    }

    public void setDomainIsDisposable(RiskCheckEmailDomainIsDisposable domainIsDisposable) {
        this.domainIsDisposable = domainIsDisposable;
    }

    public RiskCheckEmail topLevelDomainIsSuspicious(RiskCheckEmailTopLevelDomainIsSuspicious topLevelDomainIsSuspicious) {
        this.topLevelDomainIsSuspicious = topLevelDomainIsSuspicious;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public RiskCheckEmailTopLevelDomainIsSuspicious getTopLevelDomainIsSuspicious() {
        return this.topLevelDomainIsSuspicious;
    }

    public void setTopLevelDomainIsSuspicious(RiskCheckEmailTopLevelDomainIsSuspicious topLevelDomainIsSuspicious) {
        this.topLevelDomainIsSuspicious = topLevelDomainIsSuspicious;
    }

    public RiskCheckEmail linkedServices(Set<RiskCheckLinkedService> linkedServices) {
        this.linkedServices = linkedServices;
        return this;
    }

    public RiskCheckEmail addLinkedServicesItem(RiskCheckLinkedService linkedServicesItem) {
        this.linkedServices.add(linkedServicesItem);
        return this;
    }

    @ApiModelProperty(example="[\"facebook\"]", required=true, value="A list of online services where this email address has been detected to have accounts or other activity.")
    public Set<RiskCheckLinkedService> getLinkedServices() {
        return this.linkedServices;
    }

    public void setLinkedServices(Set<RiskCheckLinkedService> linkedServices) {
        this.linkedServices = linkedServices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiskCheckEmail riskCheckEmail = (RiskCheckEmail)o;
        return Objects.equals((Object)this.isDeliverable, (Object)riskCheckEmail.isDeliverable) && Objects.equals(this.breachCount, riskCheckEmail.breachCount) && Objects.equals(this.firstBreachedAt, riskCheckEmail.firstBreachedAt) && Objects.equals(this.lastBreachedAt, riskCheckEmail.lastBreachedAt) && Objects.equals(this.domainRegisteredAt, riskCheckEmail.domainRegisteredAt) && Objects.equals((Object)this.domainIsFreeProvider, (Object)riskCheckEmail.domainIsFreeProvider) && Objects.equals((Object)this.domainIsCustom, (Object)riskCheckEmail.domainIsCustom) && Objects.equals((Object)this.domainIsDisposable, (Object)riskCheckEmail.domainIsDisposable) && Objects.equals((Object)this.topLevelDomainIsSuspicious, (Object)riskCheckEmail.topLevelDomainIsSuspicious) && Objects.equals(this.linkedServices, riskCheckEmail.linkedServices);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isDeliverable, this.breachCount, this.firstBreachedAt, this.lastBreachedAt, this.domainRegisteredAt, this.domainIsFreeProvider, this.domainIsCustom, this.domainIsDisposable, this.topLevelDomainIsSuspicious, this.linkedServices});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiskCheckEmail {\n");
        sb.append("    isDeliverable: ").append(this.toIndentedString((Object)this.isDeliverable)).append("\n");
        sb.append("    breachCount: ").append(this.toIndentedString(this.breachCount)).append("\n");
        sb.append("    firstBreachedAt: ").append(this.toIndentedString(this.firstBreachedAt)).append("\n");
        sb.append("    lastBreachedAt: ").append(this.toIndentedString(this.lastBreachedAt)).append("\n");
        sb.append("    domainRegisteredAt: ").append(this.toIndentedString(this.domainRegisteredAt)).append("\n");
        sb.append("    domainIsFreeProvider: ").append(this.toIndentedString((Object)this.domainIsFreeProvider)).append("\n");
        sb.append("    domainIsCustom: ").append(this.toIndentedString((Object)this.domainIsCustom)).append("\n");
        sb.append("    domainIsDisposable: ").append(this.toIndentedString((Object)this.domainIsDisposable)).append("\n");
        sb.append("    topLevelDomainIsSuspicious: ").append(this.toIndentedString((Object)this.topLevelDomainIsSuspicious)).append("\n");
        sb.append("    linkedServices: ").append(this.toIndentedString(this.linkedServices)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

