/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.RiskCheckStolenIdentity;
import com.plaid.client.model.RiskCheckSyntheticIdentity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Result summary object capturing abuse signals related to `identity abuse`, e.g. stolen and synthetic identity fraud. These attributes are only available for US identities and some signals may not be available depending on what information was collected.")
public class RiskCheckIdentityAbuseSignals {
    public static final String SERIALIZED_NAME_SYNTHETIC_IDENTITY = "synthetic_identity";
    @SerializedName(value="synthetic_identity")
    private RiskCheckSyntheticIdentity syntheticIdentity;
    public static final String SERIALIZED_NAME_STOLEN_IDENTITY = "stolen_identity";
    @SerializedName(value="stolen_identity")
    private RiskCheckStolenIdentity stolenIdentity;

    public RiskCheckIdentityAbuseSignals syntheticIdentity(RiskCheckSyntheticIdentity syntheticIdentity) {
        this.syntheticIdentity = syntheticIdentity;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public RiskCheckSyntheticIdentity getSyntheticIdentity() {
        return this.syntheticIdentity;
    }

    public void setSyntheticIdentity(RiskCheckSyntheticIdentity syntheticIdentity) {
        this.syntheticIdentity = syntheticIdentity;
    }

    public RiskCheckIdentityAbuseSignals stolenIdentity(RiskCheckStolenIdentity stolenIdentity) {
        this.stolenIdentity = stolenIdentity;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public RiskCheckStolenIdentity getStolenIdentity() {
        return this.stolenIdentity;
    }

    public void setStolenIdentity(RiskCheckStolenIdentity stolenIdentity) {
        this.stolenIdentity = stolenIdentity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiskCheckIdentityAbuseSignals riskCheckIdentityAbuseSignals = (RiskCheckIdentityAbuseSignals)o;
        return Objects.equals(this.syntheticIdentity, riskCheckIdentityAbuseSignals.syntheticIdentity) && Objects.equals(this.stolenIdentity, riskCheckIdentityAbuseSignals.stolenIdentity);
    }

    public int hashCode() {
        return Objects.hash(this.syntheticIdentity, this.stolenIdentity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiskCheckIdentityAbuseSignals {\n");
        sb.append("    syntheticIdentity: ").append(this.toIndentedString(this.syntheticIdentity)).append("\n");
        sb.append("    stolenIdentity: ").append(this.toIndentedString(this.stolenIdentity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

