/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="This object includes a code and description to describe medium risk transactions and above on /accounts/balance/get.")
public class RiskReason {
    public static final String SERIALIZED_NAME_CODE = "code";
    @SerializedName(value="code")
    private String code;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;

    public RiskReason code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="A code that represents the type of risk associated with the proposed transaction.  The codes are from PL01 to PL08 and from BK01 to BK07. For a full listing of risk reason codes, see [Risk codes](https://plaid.com/docs/balance/balance-plus/#risk-codes).")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public RiskReason description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="A human-readable description explaining the risk code associated with the proposed transaction and some recommended actions. This field is subject to change; any programmatic logic should be based on the `code` field instead. ")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiskReason riskReason = (RiskReason)o;
        return Objects.equals(this.code, riskReason.code) && Objects.equals(this.description, riskReason.description);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiskReason {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

