/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details about the transaction result after evaluated by the requested Ruleset. If a `ruleset_key` is not provided, this field will be omitted. This feature is currently in closed beta; to request access, contact your account manager.")
public class Ruleset {
    public static final String SERIALIZED_NAME_RULESET_KEY = "ruleset_key";
    @SerializedName(value="ruleset_key")
    private String rulesetKey;
    public static final String SERIALIZED_NAME_OUTCOME = "outcome";
    @SerializedName(value="outcome")
    private String outcome;

    public Ruleset rulesetKey(String rulesetKey) {
        this.rulesetKey = rulesetKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the Ruleset used for this transaction.")
    public String getRulesetKey() {
        return this.rulesetKey;
    }

    public void setRulesetKey(String rulesetKey) {
        this.rulesetKey = rulesetKey;
    }

    public Ruleset outcome(String outcome) {
        this.outcome = outcome;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The evaluated outcome for this transaction. You can configure a list of outcomes, such as \"accept\", \"review\", and \"decline\" using the Signal dashboard located within the Plaid Dashboard.")
    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ruleset ruleset = (Ruleset)o;
        return Objects.equals(this.rulesetKey, ruleset.rulesetKey) && Objects.equals(this.outcome, ruleset.outcome);
    }

    public int hashCode() {
        return Objects.hash(this.rulesetKey, this.outcome);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Ruleset {\n");
        sb.append("    rulesetKey: ").append(this.toIndentedString(this.rulesetKey)).append("\n");
        sb.append("    outcome: ").append(this.toIndentedString(this.outcome)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

