/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.BankTransferFailure;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/sandbox/bank_transfer/simulate`")
public class SandboxBankTransferSimulateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_BANK_TRANSFER_ID = "bank_transfer_id";
    @SerializedName(value="bank_transfer_id")
    private String bankTransferId;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "event_type";
    @SerializedName(value="event_type")
    private String eventType;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failure_reason";
    @SerializedName(value="failure_reason")
    private BankTransferFailure failureReason;

    public SandboxBankTransferSimulateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SandboxBankTransferSimulateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SandboxBankTransferSimulateRequest bankTransferId(String bankTransferId) {
        this.bankTransferId = bankTransferId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a bank transfer.")
    public String getBankTransferId() {
        return this.bankTransferId;
    }

    public void setBankTransferId(String bankTransferId) {
        this.bankTransferId = bankTransferId;
    }

    public SandboxBankTransferSimulateRequest eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(required=true, value="The asynchronous event to be simulated. May be: `posted`, `failed`, or `reversed`.  An error will be returned if the event type is incompatible with the current transfer status. Compatible status --> event type transitions include:  `pending` --> `failed`  `pending` --> `posted`  `posted` --> `reversed` ")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public SandboxBankTransferSimulateRequest failureReason(BankTransferFailure failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BankTransferFailure getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(BankTransferFailure failureReason) {
        this.failureReason = failureReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SandboxBankTransferSimulateRequest sandboxBankTransferSimulateRequest = (SandboxBankTransferSimulateRequest)o;
        return Objects.equals(this.clientId, sandboxBankTransferSimulateRequest.clientId) && Objects.equals(this.secret, sandboxBankTransferSimulateRequest.secret) && Objects.equals(this.bankTransferId, sandboxBankTransferSimulateRequest.bankTransferId) && Objects.equals(this.eventType, sandboxBankTransferSimulateRequest.eventType) && Objects.equals(this.failureReason, sandboxBankTransferSimulateRequest.failureReason);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.bankTransferId, this.eventType, this.failureReason);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SandboxBankTransferSimulateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    bankTransferId: ").append(this.toIndentedString(this.bankTransferId)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

