/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.SandboxIncomeWebhookFireRequestWebhookCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SandboxIncomeFireWebhookRequest defines the request schema for `/sandbox/income/fire_webhook`")
public class SandboxIncomeFireWebhookRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private String webhook;
    public static final String SERIALIZED_NAME_VERIFICATION_STATUS = "verification_status";
    @SerializedName(value="verification_status")
    private VerificationStatusEnum verificationStatus;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private SandboxIncomeWebhookFireRequestWebhookCode webhookCode;

    public SandboxIncomeFireWebhookRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SandboxIncomeFireWebhookRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SandboxIncomeFireWebhookRequest itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Item ID associated with the verification.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public SandboxIncomeFireWebhookRequest userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid `user_id` of the User associated with this webhook, warning, or error.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public SandboxIncomeFireWebhookRequest webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL to which the webhook should be sent.")
    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public SandboxIncomeFireWebhookRequest verificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`VERIFICATION_STATUS_PROCESSING_COMPLETE`: The income verification status processing has completed. If the user uploaded multiple documents, this webhook will fire when all documents have finished processing. Call the `/income/verification/paystubs/get` endpoint and check the document metadata to see which documents were successfully parsed.  `VERIFICATION_STATUS_PROCESSING_FAILED`: A failure occurred when attempting to process the verification documentation.  `VERIFICATION_STATUS_PENDING_APPROVAL`: (deprecated) The income verification has been sent to the user for review.")
    public VerificationStatusEnum getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public SandboxIncomeFireWebhookRequest webhookCode(SandboxIncomeWebhookFireRequestWebhookCode webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public SandboxIncomeWebhookFireRequestWebhookCode getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(SandboxIncomeWebhookFireRequestWebhookCode webhookCode) {
        this.webhookCode = webhookCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SandboxIncomeFireWebhookRequest sandboxIncomeFireWebhookRequest = (SandboxIncomeFireWebhookRequest)o;
        return Objects.equals(this.clientId, sandboxIncomeFireWebhookRequest.clientId) && Objects.equals(this.secret, sandboxIncomeFireWebhookRequest.secret) && Objects.equals(this.itemId, sandboxIncomeFireWebhookRequest.itemId) && Objects.equals(this.userId, sandboxIncomeFireWebhookRequest.userId) && Objects.equals(this.webhook, sandboxIncomeFireWebhookRequest.webhook) && Objects.equals((Object)this.verificationStatus, (Object)sandboxIncomeFireWebhookRequest.verificationStatus) && Objects.equals((Object)this.webhookCode, (Object)sandboxIncomeFireWebhookRequest.webhookCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.itemId, this.userId, this.webhook, this.verificationStatus, this.webhookCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SandboxIncomeFireWebhookRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString((Object)this.webhookCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerificationStatusEnum {
        PROCESSING_COMPLETE("VERIFICATION_STATUS_PROCESSING_COMPLETE"),
        PROCESSING_FAILED("VERIFICATION_STATUS_PROCESSING_FAILED"),
        PENDING_APPROVAL("VERIFICATION_STATUS_PENDING_APPROVAL");

        private String value;

        private VerificationStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerificationStatusEnum fromValue(String value) {
            for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VerificationStatusEnum> {
            public void write(JsonWriter jsonWriter, VerificationStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerificationStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerificationStatusEnum.fromValue(value);
            }
        }
    }
}

