/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.WebhookType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SandboxItemFireWebhookRequest defines the request schema for `/sandbox/item/fire_webhook`")
public class SandboxItemFireWebhookRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private WebhookType webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private WebhookCodeEnum webhookCode;

    public SandboxItemFireWebhookRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SandboxItemFireWebhookRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SandboxItemFireWebhookRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public SandboxItemFireWebhookRequest webhookType(WebhookType webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WebhookType getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(WebhookType webhookType) {
        this.webhookType = webhookType;
    }

    public SandboxItemFireWebhookRequest webhookCode(WebhookCodeEnum webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The webhook codes that can be fired by this test endpoint.")
    public WebhookCodeEnum getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(WebhookCodeEnum webhookCode) {
        this.webhookCode = webhookCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SandboxItemFireWebhookRequest sandboxItemFireWebhookRequest = (SandboxItemFireWebhookRequest)o;
        return Objects.equals(this.clientId, sandboxItemFireWebhookRequest.clientId) && Objects.equals(this.secret, sandboxItemFireWebhookRequest.secret) && Objects.equals(this.accessToken, sandboxItemFireWebhookRequest.accessToken) && Objects.equals((Object)this.webhookType, (Object)sandboxItemFireWebhookRequest.webhookType) && Objects.equals((Object)this.webhookCode, (Object)sandboxItemFireWebhookRequest.webhookCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.accessToken, this.webhookType, this.webhookCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SandboxItemFireWebhookRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    webhookType: ").append(this.toIndentedString((Object)this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString((Object)this.webhookCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WebhookCodeEnum {
        DEFAULT_UPDATE("DEFAULT_UPDATE"),
        NEW_ACCOUNTS_AVAILABLE("NEW_ACCOUNTS_AVAILABLE"),
        SMS_MICRODEPOSITS_VERIFICATION("SMS_MICRODEPOSITS_VERIFICATION"),
        AUTHORIZATION_GRANTED("AUTHORIZATION_GRANTED"),
        RECURRING_TRANSACTIONS_UPDATE("RECURRING_TRANSACTIONS_UPDATE"),
        SYNC_UPDATES_AVAILABLE("SYNC_UPDATES_AVAILABLE"),
        PRODUCT_READY("PRODUCT_READY"),
        ERROR("ERROR");

        private String value;

        private WebhookCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WebhookCodeEnum fromValue(String value) {
            for (WebhookCodeEnum b : WebhookCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<WebhookCodeEnum> {
            public void write(JsonWriter jsonWriter, WebhookCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WebhookCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WebhookCodeEnum.fromValue(value);
            }
        }
    }
}

