/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SandboxItemSetVerificationStatusRequest defines the request schema for `/sandbox/item/set_verification_status`")
public class SandboxItemSetVerificationStatusRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_VERIFICATION_STATUS = "verification_status";
    @SerializedName(value="verification_status")
    private VerificationStatusEnum verificationStatus;

    public SandboxItemSetVerificationStatusRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SandboxItemSetVerificationStatusRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SandboxItemSetVerificationStatusRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The access token associated with the Item data is being requested for.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public SandboxItemSetVerificationStatusRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The `account_id` of the account whose verification status is to be modified")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public SandboxItemSetVerificationStatusRequest verificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="The verification status to set the account to.")
    public VerificationStatusEnum getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SandboxItemSetVerificationStatusRequest sandboxItemSetVerificationStatusRequest = (SandboxItemSetVerificationStatusRequest)o;
        return Objects.equals(this.clientId, sandboxItemSetVerificationStatusRequest.clientId) && Objects.equals(this.secret, sandboxItemSetVerificationStatusRequest.secret) && Objects.equals(this.accessToken, sandboxItemSetVerificationStatusRequest.accessToken) && Objects.equals(this.accountId, sandboxItemSetVerificationStatusRequest.accountId) && Objects.equals((Object)this.verificationStatus, (Object)sandboxItemSetVerificationStatusRequest.verificationStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.accessToken, this.accountId, this.verificationStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SandboxItemSetVerificationStatusRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerificationStatusEnum {
        AUTOMATICALLY_VERIFIED("automatically_verified"),
        VERIFICATION_EXPIRED("verification_expired");

        private String value;

        private VerificationStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerificationStatusEnum fromValue(String value) {
            for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VerificationStatusEnum> {
            public void write(JsonWriter jsonWriter, VerificationStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerificationStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerificationStatusEnum.fromValue(value);
            }
        }
    }
}

