/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Products;
import com.plaid.client.model.SandboxPublicTokenCreateRequestOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SandboxPublicTokenCreateRequest defines the request schema for `/sandbox/public_token/create`")
public class SandboxPublicTokenCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_INITIAL_PRODUCTS = "initial_products";
    @SerializedName(value="initial_products")
    private List<Products> initialProducts = new ArrayList<Products>();
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private SandboxPublicTokenCreateRequestOptions options;
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;

    public SandboxPublicTokenCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SandboxPublicTokenCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SandboxPublicTokenCreateRequest institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the institution the Item will be associated with")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public SandboxPublicTokenCreateRequest initialProducts(List<Products> initialProducts) {
        this.initialProducts = initialProducts;
        return this;
    }

    public SandboxPublicTokenCreateRequest addInitialProductsItem(Products initialProductsItem) {
        this.initialProducts.add(initialProductsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The products to initially pull for the Item. May be any products that the specified `institution_id`  supports. This array may not be empty.")
    public List<Products> getInitialProducts() {
        return this.initialProducts;
    }

    public void setInitialProducts(List<Products> initialProducts) {
        this.initialProducts = initialProducts;
    }

    public SandboxPublicTokenCreateRequest options(SandboxPublicTokenCreateRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SandboxPublicTokenCreateRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(SandboxPublicTokenCreateRequestOptions options) {
        this.options = options;
    }

    public SandboxPublicTokenCreateRequest userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user token associated with the User data is being requested for.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SandboxPublicTokenCreateRequest sandboxPublicTokenCreateRequest = (SandboxPublicTokenCreateRequest)o;
        return Objects.equals(this.clientId, sandboxPublicTokenCreateRequest.clientId) && Objects.equals(this.secret, sandboxPublicTokenCreateRequest.secret) && Objects.equals(this.institutionId, sandboxPublicTokenCreateRequest.institutionId) && Objects.equals(this.initialProducts, sandboxPublicTokenCreateRequest.initialProducts) && Objects.equals(this.options, sandboxPublicTokenCreateRequest.options) && Objects.equals(this.userToken, sandboxPublicTokenCreateRequest.userToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.institutionId, this.initialProducts, this.options, this.userToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SandboxPublicTokenCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    initialProducts: ").append(this.toIndentedString(this.initialProducts)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

