/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An optional set of parameters corresponding to transactions options.")
public class SandboxPublicTokenCreateRequestOptionsTransactions {
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_DAYS_REQUESTED = "days_requested";
    @SerializedName(value="days_requested")
    private Integer daysRequested = 90;

    public SandboxPublicTokenCreateRequestOptionsTransactions startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The earliest date for which to fetch transaction history. Dates should be formatted as YYYY-MM-DD.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public SandboxPublicTokenCreateRequestOptionsTransactions endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The most recent date for which to fetch transaction history. Dates should be formatted as YYYY-MM-DD.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public SandboxPublicTokenCreateRequestOptionsTransactions daysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of days of transaction history to request for the Transactions product.")
    public Integer getDaysRequested() {
        return this.daysRequested;
    }

    public void setDaysRequested(Integer daysRequested) {
        this.daysRequested = daysRequested;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SandboxPublicTokenCreateRequestOptionsTransactions sandboxPublicTokenCreateRequestOptionsTransactions = (SandboxPublicTokenCreateRequestOptionsTransactions)o;
        return Objects.equals(this.startDate, sandboxPublicTokenCreateRequestOptionsTransactions.startDate) && Objects.equals(this.endDate, sandboxPublicTokenCreateRequestOptionsTransactions.endDate) && Objects.equals(this.daysRequested, sandboxPublicTokenCreateRequestOptionsTransactions.daysRequested);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.daysRequested);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SandboxPublicTokenCreateRequestOptionsTransactions {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    daysRequested: ").append(this.toIndentedString(this.daysRequested)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

