/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferFailure;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/sandbox/transfer/simulate`")
public class SandboxTransferSimulateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_TRANSFER_ID = "transfer_id";
    @SerializedName(value="transfer_id")
    private String transferId;
    public static final String SERIALIZED_NAME_TEST_CLOCK_ID = "test_clock_id";
    @SerializedName(value="test_clock_id")
    private String testClockId;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "event_type";
    @SerializedName(value="event_type")
    private String eventType;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failure_reason";
    @SerializedName(value="failure_reason")
    private TransferFailure failureReason;

    public SandboxTransferSimulateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SandboxTransferSimulateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SandboxTransferSimulateRequest transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a transfer.")
    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public SandboxTransferSimulateRequest testClockId(String testClockId) {
        this.testClockId = testClockId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for a test clock. If provided, the event to be simulated is created at the `virtual_time` on the provided `test_clock`.")
    public String getTestClockId() {
        return this.testClockId;
    }

    public void setTestClockId(String testClockId) {
        this.testClockId = testClockId;
    }

    public SandboxTransferSimulateRequest eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(required=true, value="The asynchronous event to be simulated. May be: `posted`, `settled`, `failed`, or `returned`.  An error will be returned if the event type is incompatible with the current transfer status. Compatible status --> event type transitions include:  `pending` --> `failed`  `pending` --> `posted`  `posted` --> `returned`  `posted` --> `settled` ")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public SandboxTransferSimulateRequest failureReason(TransferFailure failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferFailure getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(TransferFailure failureReason) {
        this.failureReason = failureReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SandboxTransferSimulateRequest sandboxTransferSimulateRequest = (SandboxTransferSimulateRequest)o;
        return Objects.equals(this.clientId, sandboxTransferSimulateRequest.clientId) && Objects.equals(this.secret, sandboxTransferSimulateRequest.secret) && Objects.equals(this.transferId, sandboxTransferSimulateRequest.transferId) && Objects.equals(this.testClockId, sandboxTransferSimulateRequest.testClockId) && Objects.equals(this.eventType, sandboxTransferSimulateRequest.eventType) && Objects.equals(this.failureReason, sandboxTransferSimulateRequest.failureReason);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.transferId, this.testClockId, this.eventType, this.failureReason);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SandboxTransferSimulateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    testClockId: ").append(this.toIndentedString(this.testClockId)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

