/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/sandbox/transfer/test_clock/advance`")
public class SandboxTransferTestClockAdvanceRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_TEST_CLOCK_ID = "test_clock_id";
    @SerializedName(value="test_clock_id")
    private String testClockId;
    public static final String SERIALIZED_NAME_NEW_VIRTUAL_TIME = "new_virtual_time";
    @SerializedName(value="new_virtual_time")
    private OffsetDateTime newVirtualTime;

    public SandboxTransferTestClockAdvanceRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SandboxTransferTestClockAdvanceRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SandboxTransferTestClockAdvanceRequest testClockId(String testClockId) {
        this.testClockId = testClockId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a test clock.")
    public String getTestClockId() {
        return this.testClockId;
    }

    public void setTestClockId(String testClockId) {
        this.testClockId = testClockId;
    }

    public SandboxTransferTestClockAdvanceRequest newVirtualTime(OffsetDateTime newVirtualTime) {
        this.newVirtualTime = newVirtualTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The virtual timestamp on the test clock. This will be of the form `2006-01-02T15:04:05Z`.")
    public OffsetDateTime getNewVirtualTime() {
        return this.newVirtualTime;
    }

    public void setNewVirtualTime(OffsetDateTime newVirtualTime) {
        this.newVirtualTime = newVirtualTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SandboxTransferTestClockAdvanceRequest sandboxTransferTestClockAdvanceRequest = (SandboxTransferTestClockAdvanceRequest)o;
        return Objects.equals(this.clientId, sandboxTransferTestClockAdvanceRequest.clientId) && Objects.equals(this.secret, sandboxTransferTestClockAdvanceRequest.secret) && Objects.equals(this.testClockId, sandboxTransferTestClockAdvanceRequest.testClockId) && Objects.equals(this.newVirtualTime, sandboxTransferTestClockAdvanceRequest.newVirtualTime);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.testClockId, this.newVirtualTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SandboxTransferTestClockAdvanceRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    testClockId: ").append(this.toIndentedString(this.testClockId)).append("\n");
        sb.append("    newVirtualTime: ").append(this.toIndentedString(this.newVirtualTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

