/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/sandbox/transfer/test_clock/create`")
public class SandboxTransferTestClockCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_VIRTUAL_TIME = "virtual_time";
    @SerializedName(value="virtual_time")
    private OffsetDateTime virtualTime;

    public SandboxTransferTestClockCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SandboxTransferTestClockCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SandboxTransferTestClockCreateRequest virtualTime(OffsetDateTime virtualTime) {
        this.virtualTime = virtualTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The virtual timestamp on the test clock. If not provided, the current timestamp will be used. This will be of the form `2006-01-02T15:04:05Z`.")
    public OffsetDateTime getVirtualTime() {
        return this.virtualTime;
    }

    public void setVirtualTime(OffsetDateTime virtualTime) {
        this.virtualTime = virtualTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SandboxTransferTestClockCreateRequest sandboxTransferTestClockCreateRequest = (SandboxTransferTestClockCreateRequest)o;
        return Objects.equals(this.clientId, sandboxTransferTestClockCreateRequest.clientId) && Objects.equals(this.secret, sandboxTransferTestClockCreateRequest.secret) && Objects.equals(this.virtualTime, sandboxTransferTestClockCreateRequest.virtualTime);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.virtualTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SandboxTransferTestClockCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    virtualTime: ").append(this.toIndentedString(this.virtualTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

