/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/sandbox/transfer/test_clock/list`")
public class SandboxTransferTestClockListRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_START_VIRTUAL_TIME = "start_virtual_time";
    @SerializedName(value="start_virtual_time")
    private OffsetDateTime startVirtualTime;
    public static final String SERIALIZED_NAME_END_VIRTUAL_TIME = "end_virtual_time";
    @SerializedName(value="end_virtual_time")
    private OffsetDateTime endVirtualTime;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 25;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private Integer offset = 0;

    public SandboxTransferTestClockListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public SandboxTransferTestClockListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public SandboxTransferTestClockListRequest startVirtualTime(OffsetDateTime startVirtualTime) {
        this.startVirtualTime = startVirtualTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start virtual timestamp of test clocks to return. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)")
    public OffsetDateTime getStartVirtualTime() {
        return this.startVirtualTime;
    }

    public void setStartVirtualTime(OffsetDateTime startVirtualTime) {
        this.startVirtualTime = startVirtualTime;
    }

    public SandboxTransferTestClockListRequest endVirtualTime(OffsetDateTime endVirtualTime) {
        this.endVirtualTime = endVirtualTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end virtual timestamp of test clocks to return. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)")
    public OffsetDateTime getEndVirtualTime() {
        return this.endVirtualTime;
    }

    public void setEndVirtualTime(OffsetDateTime endVirtualTime) {
        this.endVirtualTime = endVirtualTime;
    }

    public SandboxTransferTestClockListRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of test clocks to return.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public SandboxTransferTestClockListRequest offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of test clocks to skip before returning results.")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SandboxTransferTestClockListRequest sandboxTransferTestClockListRequest = (SandboxTransferTestClockListRequest)o;
        return Objects.equals(this.clientId, sandboxTransferTestClockListRequest.clientId) && Objects.equals(this.secret, sandboxTransferTestClockListRequest.secret) && Objects.equals(this.startVirtualTime, sandboxTransferTestClockListRequest.startVirtualTime) && Objects.equals(this.endVirtualTime, sandboxTransferTestClockListRequest.endVirtualTime) && Objects.equals(this.count, sandboxTransferTestClockListRequest.count) && Objects.equals(this.offset, sandboxTransferTestClockListRequest.offset);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.startVirtualTime, this.endVirtualTime, this.count, this.offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SandboxTransferTestClockListRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    startVirtualTime: ").append(this.toIndentedString(this.startVirtualTime)).append("\n");
        sb.append("    endVirtualTime: ").append(this.toIndentedString(this.endVirtualTime)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

