/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.MatchSummaryCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Analysis information describing why a screening hit matched the provided user information")
public class ScreeningHitAnalysis {
    public static final String SERIALIZED_NAME_DATES_OF_BIRTH = "dates_of_birth";
    @SerializedName(value="dates_of_birth")
    private MatchSummaryCode datesOfBirth;
    public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
    @SerializedName(value="documents")
    private MatchSummaryCode documents;
    public static final String SERIALIZED_NAME_LOCATIONS = "locations";
    @SerializedName(value="locations")
    private MatchSummaryCode locations;
    public static final String SERIALIZED_NAME_NAMES = "names";
    @SerializedName(value="names")
    private MatchSummaryCode names;
    public static final String SERIALIZED_NAME_SEARCH_TERMS_VERSION = "search_terms_version";
    @SerializedName(value="search_terms_version")
    private Integer searchTermsVersion;

    public ScreeningHitAnalysis datesOfBirth(MatchSummaryCode datesOfBirth) {
        this.datesOfBirth = datesOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MatchSummaryCode getDatesOfBirth() {
        return this.datesOfBirth;
    }

    public void setDatesOfBirth(MatchSummaryCode datesOfBirth) {
        this.datesOfBirth = datesOfBirth;
    }

    public ScreeningHitAnalysis documents(MatchSummaryCode documents) {
        this.documents = documents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MatchSummaryCode getDocuments() {
        return this.documents;
    }

    public void setDocuments(MatchSummaryCode documents) {
        this.documents = documents;
    }

    public ScreeningHitAnalysis locations(MatchSummaryCode locations) {
        this.locations = locations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MatchSummaryCode getLocations() {
        return this.locations;
    }

    public void setLocations(MatchSummaryCode locations) {
        this.locations = locations;
    }

    public ScreeningHitAnalysis names(MatchSummaryCode names) {
        this.names = names;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MatchSummaryCode getNames() {
        return this.names;
    }

    public void setNames(MatchSummaryCode names) {
        this.names = names;
    }

    public ScreeningHitAnalysis searchTermsVersion(Integer searchTermsVersion) {
        this.searchTermsVersion = searchTermsVersion;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The version of the screening's `search_terms` that were compared when the screening hit was added. screening hits are immutable once they have been reviewed. If changes are detected due to updates to the screening's `search_terms`, the associated program, or the list's source data prior to review, the screening hit will be updated to reflect those changes.")
    public Integer getSearchTermsVersion() {
        return this.searchTermsVersion;
    }

    public void setSearchTermsVersion(Integer searchTermsVersion) {
        this.searchTermsVersion = searchTermsVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreeningHitAnalysis screeningHitAnalysis = (ScreeningHitAnalysis)o;
        return Objects.equals((Object)this.datesOfBirth, (Object)screeningHitAnalysis.datesOfBirth) && Objects.equals((Object)this.documents, (Object)screeningHitAnalysis.documents) && Objects.equals((Object)this.locations, (Object)screeningHitAnalysis.locations) && Objects.equals((Object)this.names, (Object)screeningHitAnalysis.names) && Objects.equals(this.searchTermsVersion, screeningHitAnalysis.searchTermsVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.datesOfBirth, this.documents, this.locations, this.names, this.searchTermsVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScreeningHitAnalysis {\n");
        sb.append("    datesOfBirth: ").append(this.toIndentedString((Object)this.datesOfBirth)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString((Object)this.documents)).append("\n");
        sb.append("    locations: ").append(this.toIndentedString((Object)this.locations)).append("\n");
        sb.append("    names: ").append(this.toIndentedString((Object)this.names)).append("\n");
        sb.append("    searchTermsVersion: ").append(this.toIndentedString(this.searchTermsVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

