/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.OptionContract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains details about a security")
public class Security {
    public static final String SERIALIZED_NAME_SECURITY_ID = "security_id";
    @SerializedName(value="security_id")
    private String securityId;
    public static final String SERIALIZED_NAME_ISIN = "isin";
    @SerializedName(value="isin")
    private String isin;
    public static final String SERIALIZED_NAME_CUSIP = "cusip";
    @SerializedName(value="cusip")
    private String cusip;
    public static final String SERIALIZED_NAME_SEDOL = "sedol";
    @SerializedName(value="sedol")
    private String sedol;
    public static final String SERIALIZED_NAME_INSTITUTION_SECURITY_ID = "institution_security_id";
    @SerializedName(value="institution_security_id")
    private String institutionSecurityId;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_PROXY_SECURITY_ID = "proxy_security_id";
    @SerializedName(value="proxy_security_id")
    private String proxySecurityId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TICKER_SYMBOL = "ticker_symbol";
    @SerializedName(value="ticker_symbol")
    private String tickerSymbol;
    public static final String SERIALIZED_NAME_IS_CASH_EQUIVALENT = "is_cash_equivalent";
    @SerializedName(value="is_cash_equivalent")
    private Boolean isCashEquivalent;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_CLOSE_PRICE = "close_price";
    @SerializedName(value="close_price")
    private Double closePrice;
    public static final String SERIALIZED_NAME_CLOSE_PRICE_AS_OF = "close_price_as_of";
    @SerializedName(value="close_price_as_of")
    private LocalDate closePriceAsOf;
    public static final String SERIALIZED_NAME_UPDATE_DATETIME = "update_datetime";
    @SerializedName(value="update_datetime")
    private OffsetDateTime updateDatetime;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_MARKET_IDENTIFIER_CODE = "market_identifier_code";
    @SerializedName(value="market_identifier_code")
    private String marketIdentifierCode;
    public static final String SERIALIZED_NAME_OPTION_CONTRACT = "option_contract";
    @SerializedName(value="option_contract")
    private OptionContract optionContract;

    public Security securityId(String securityId) {
        this.securityId = securityId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique, Plaid-specific identifier for the security, used to associate securities with holdings. Like all Plaid identifiers, the `security_id` is case sensitive. The `security_id` may change if inherent details of the security change due to a corporate action, for example, in the event of a ticker symbol change or CUSIP change.")
    public String getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public Security isin(String isin) {
        this.isin = isin;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="12-character ISIN, a globally unique securities identifier. A verified CUSIP Global Services license is required to receive this data. This field will be null by default for new customers, and null for existing customers starting March 12, 2024. If you would like access to this field, please start the verification process [here](https://docs.google.com/forms/d/e/1FAIpQLSd9asHEYEfmf8fxJTHZTAfAzW4dugsnSu-HS2J51f1mxwd6Sw/viewform).")
    public String getIsin() {
        return this.isin;
    }

    public void setIsin(String isin) {
        this.isin = isin;
    }

    public Security cusip(String cusip) {
        this.cusip = cusip;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="9-character CUSIP, an identifier assigned to North American securities. A verified CUSIP Global Services license is required to receive this data. This field will be null by default for new customers, and null for existing customers starting March 12, 2024. If you would like access to this field, please start the verification process [here](https://docs.google.com/forms/d/e/1FAIpQLSd9asHEYEfmf8fxJTHZTAfAzW4dugsnSu-HS2J51f1mxwd6Sw/viewform).")
    public String getCusip() {
        return this.cusip;
    }

    public void setCusip(String cusip) {
        this.cusip = cusip;
    }

    public Security sedol(String sedol) {
        this.sedol = sedol;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="7-character SEDOL, an identifier assigned to securities in the UK.")
    public String getSedol() {
        return this.sedol;
    }

    public void setSedol(String sedol) {
        this.sedol = sedol;
    }

    public Security institutionSecurityId(String institutionSecurityId) {
        this.institutionSecurityId = institutionSecurityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="An identifier given to the security by the institution")
    public String getInstitutionSecurityId() {
        return this.institutionSecurityId;
    }

    public void setInstitutionSecurityId(String institutionSecurityId) {
        this.institutionSecurityId = institutionSecurityId;
    }

    public Security institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="If `institution_security_id` is present, this field indicates the Plaid `institution_id` of the institution to whom the identifier belongs.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public Security proxySecurityId(String proxySecurityId) {
        this.proxySecurityId = proxySecurityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="In certain cases, Plaid will provide the ID of another security whose performance resembles this security, typically when the original security has low volume, or when a private security can be modeled with a publicly traded security.")
    public String getProxySecurityId() {
        return this.proxySecurityId;
    }

    public void setProxySecurityId(String proxySecurityId) {
        this.proxySecurityId = proxySecurityId;
    }

    public Security name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A descriptive name for the security, suitable for display.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Security tickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The security\u2019s trading symbol for publicly traded securities, and otherwise a short identifier if available.")
    public String getTickerSymbol() {
        return this.tickerSymbol;
    }

    public void setTickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
    }

    public Security isCashEquivalent(Boolean isCashEquivalent) {
        this.isCashEquivalent = isCashEquivalent;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Indicates that a security is a highly liquid asset and can be treated like cash.")
    public Boolean getIsCashEquivalent() {
        return this.isCashEquivalent;
    }

    public void setIsCashEquivalent(Boolean isCashEquivalent) {
        this.isCashEquivalent = isCashEquivalent;
    }

    public Security type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The security type of the holding.  In rare instances, a null value is returned when institutional data is insufficient to determine the security type.  Valid security types are:  `cash`: Cash, currency, and money market funds  `cryptocurrency`: Digital or virtual currencies  `derivative`: Options, warrants, and other derivative instruments  `equity`: Domestic and foreign equities  `etf`: Multi-asset exchange-traded investment funds  `fixed income`: Bonds and certificates of deposit (CDs)  `loan`: Loans and loan receivables  `mutual fund`: Open- and closed-end vehicles pooling funds of multiple investors  `other`: Unknown or other investment types")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Security closePrice(Double closePrice) {
        this.closePrice = closePrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Price of the security at the close of the previous trading session. Null for non-public securities.  If the security is a foreign currency this field will be updated daily and will be priced in USD.  If the security is a cryptocurrency, this field will be updated multiple times a day. As crypto prices can fluctuate quickly and data may become stale sooner than other asset classes, refer to `update_datetime` with the time when the price was last updated. ")
    public Double getClosePrice() {
        return this.closePrice;
    }

    public void setClosePrice(Double closePrice) {
        this.closePrice = closePrice;
    }

    public Security closePriceAsOf(LocalDate closePriceAsOf) {
        this.closePriceAsOf = closePriceAsOf;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Date for which `close_price` is accurate. Always `null` if `close_price` is `null`.")
    public LocalDate getClosePriceAsOf() {
        return this.closePriceAsOf;
    }

    public void setClosePriceAsOf(LocalDate closePriceAsOf) {
        this.closePriceAsOf = closePriceAsOf;
    }

    public Security updateDatetime(OffsetDateTime updateDatetime) {
        this.updateDatetime = updateDatetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date and time at which `close_price` is accurate, in ISO 8601 format (YYYY-MM-DDTHH:mm:ssZ). Always `null` if `close_price` is `null`.")
    public OffsetDateTime getUpdateDatetime() {
        return this.updateDatetime;
    }

    public void setUpdateDatetime(OffsetDateTime updateDatetime) {
        this.updateDatetime = updateDatetime;
    }

    public Security isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the price given. Always `null` if `unofficial_currency_code` is non-`null`.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public Security unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the security. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public Security marketIdentifierCode(String marketIdentifierCode) {
        this.marketIdentifierCode = marketIdentifierCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-10383 Market Identifier Code of the exchange or market in which the security is being traded.")
    public String getMarketIdentifierCode() {
        return this.marketIdentifierCode;
    }

    public void setMarketIdentifierCode(String marketIdentifierCode) {
        this.marketIdentifierCode = marketIdentifierCode;
    }

    public Security optionContract(OptionContract optionContract) {
        this.optionContract = optionContract;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public OptionContract getOptionContract() {
        return this.optionContract;
    }

    public void setOptionContract(OptionContract optionContract) {
        this.optionContract = optionContract;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Security security = (Security)o;
        return Objects.equals(this.securityId, security.securityId) && Objects.equals(this.isin, security.isin) && Objects.equals(this.cusip, security.cusip) && Objects.equals(this.sedol, security.sedol) && Objects.equals(this.institutionSecurityId, security.institutionSecurityId) && Objects.equals(this.institutionId, security.institutionId) && Objects.equals(this.proxySecurityId, security.proxySecurityId) && Objects.equals(this.name, security.name) && Objects.equals(this.tickerSymbol, security.tickerSymbol) && Objects.equals(this.isCashEquivalent, security.isCashEquivalent) && Objects.equals(this.type, security.type) && Objects.equals(this.closePrice, security.closePrice) && Objects.equals(this.closePriceAsOf, security.closePriceAsOf) && Objects.equals(this.updateDatetime, security.updateDatetime) && Objects.equals(this.isoCurrencyCode, security.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, security.unofficialCurrencyCode) && Objects.equals(this.marketIdentifierCode, security.marketIdentifierCode) && Objects.equals(this.optionContract, security.optionContract);
    }

    public int hashCode() {
        return Objects.hash(this.securityId, this.isin, this.cusip, this.sedol, this.institutionSecurityId, this.institutionId, this.proxySecurityId, this.name, this.tickerSymbol, this.isCashEquivalent, this.type, this.closePrice, this.closePriceAsOf, this.updateDatetime, this.isoCurrencyCode, this.unofficialCurrencyCode, this.marketIdentifierCode, this.optionContract);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Security {\n");
        sb.append("    securityId: ").append(this.toIndentedString(this.securityId)).append("\n");
        sb.append("    isin: ").append(this.toIndentedString(this.isin)).append("\n");
        sb.append("    cusip: ").append(this.toIndentedString(this.cusip)).append("\n");
        sb.append("    sedol: ").append(this.toIndentedString(this.sedol)).append("\n");
        sb.append("    institutionSecurityId: ").append(this.toIndentedString(this.institutionSecurityId)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    proxySecurityId: ").append(this.toIndentedString(this.proxySecurityId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tickerSymbol: ").append(this.toIndentedString(this.tickerSymbol)).append("\n");
        sb.append("    isCashEquivalent: ").append(this.toIndentedString(this.isCashEquivalent)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    closePrice: ").append(this.toIndentedString(this.closePrice)).append("\n");
        sb.append("    closePriceAsOf: ").append(this.toIndentedString(this.closePriceAsOf)).append("\n");
        sb.append("    updateDatetime: ").append(this.toIndentedString(this.updateDatetime)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    marketIdentifierCode: ").append(this.toIndentedString(this.marketIdentifierCode)).append("\n");
        sb.append("    optionContract: ").append(this.toIndentedString(this.optionContract)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

