/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specify the security associated with the holding or investment transaction. When inputting custom security data to the Sandbox, Plaid will perform post-data-retrieval normalization and enrichment. These processes may cause the data returned by the Sandbox to be slightly different from the data you input. An ISO-4217 currency code and a security identifier (`ticker_symbol`, `cusip`, `isin`, or `sedol`) are required.")
public class SecurityOverride {
    public static final String SERIALIZED_NAME_ISIN = "isin";
    @SerializedName(value="isin")
    private String isin;
    public static final String SERIALIZED_NAME_CUSIP = "cusip";
    @SerializedName(value="cusip")
    private String cusip;
    public static final String SERIALIZED_NAME_SEDOL = "sedol";
    @SerializedName(value="sedol")
    private String sedol;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TICKER_SYMBOL = "ticker_symbol";
    @SerializedName(value="ticker_symbol")
    private String tickerSymbol;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;

    public SecurityOverride isin(String isin) {
        this.isin = isin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="12-character ISIN, a globally unique securities identifier. A verified CUSIP Global Services license is required to receive this data. This field will be null by default for new customers, and null for existing customers starting March 12, 2024. If you would like access to this field, please [request ISIN/CUSIP access here](https://docs.google.com/forms/d/e/1FAIpQLSd9asHEYEfmf8fxJTHZTAfAzW4dugsnSu-HS2J51f1mxwd6Sw/viewform).")
    public String getIsin() {
        return this.isin;
    }

    public void setIsin(String isin) {
        this.isin = isin;
    }

    public SecurityOverride cusip(String cusip) {
        this.cusip = cusip;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="9-character CUSIP, an identifier assigned to North American securities. A verified CUSIP Global Services license is required to receive this data. This field will be null by default for new customers, and null for existing customers starting March 12, 2024. If you would like access to this field, please [request ISIN/CUSIP access here](https://docs.google.com/forms/d/e/1FAIpQLSd9asHEYEfmf8fxJTHZTAfAzW4dugsnSu-HS2J51f1mxwd6Sw/viewform).")
    public String getCusip() {
        return this.cusip;
    }

    public void setCusip(String cusip) {
        this.cusip = cusip;
    }

    public SecurityOverride sedol(String sedol) {
        this.sedol = sedol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="7-character SEDOL, an identifier assigned to securities in the UK.")
    public String getSedol() {
        return this.sedol;
    }

    public void setSedol(String sedol) {
        this.sedol = sedol;
    }

    public SecurityOverride name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A descriptive name for the security, suitable for display.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SecurityOverride tickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The security\u2019s trading symbol for publicly traded securities, and otherwise a short identifier if available.")
    public String getTickerSymbol() {
        return this.tickerSymbol;
    }

    public void setTickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
    }

    public SecurityOverride currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Either a valid `iso_currency_code` or `unofficial_currency_code`")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityOverride securityOverride = (SecurityOverride)o;
        return Objects.equals(this.isin, securityOverride.isin) && Objects.equals(this.cusip, securityOverride.cusip) && Objects.equals(this.sedol, securityOverride.sedol) && Objects.equals(this.name, securityOverride.name) && Objects.equals(this.tickerSymbol, securityOverride.tickerSymbol) && Objects.equals(this.currency, securityOverride.currency);
    }

    public int hashCode() {
        return Objects.hash(this.isin, this.cusip, this.sedol, this.name, this.tickerSymbol, this.currency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityOverride {\n");
        sb.append("    isin: ").append(this.toIndentedString(this.isin)).append("\n");
        sb.append("    cusip: ").append(this.toIndentedString(this.cusip)).append("\n");
        sb.append("    sedol: ").append(this.toIndentedString(this.sedol)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tickerSymbol: ").append(this.toIndentedString(this.tickerSymbol)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

