/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The image or video capture of a selfie. Only one of image or video URL will be populated per selfie.")
public class SelfieCapture {
    public static final String SERIALIZED_NAME_IMAGE_URL = "image_url";
    @SerializedName(value="image_url")
    private String imageUrl;
    public static final String SERIALIZED_NAME_VIDEO_URL = "video_url";
    @SerializedName(value="video_url")
    private String videoUrl;

    public SelfieCapture imageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.plaid.com/verifications/idv_52xR9LKo77r1Np/selfie/liveness.jpeg", required=true, value="Temporary URL for downloading an image selfie capture.")
    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public SelfieCapture videoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.plaid.com/verifications/idv_52xR9LKo77r1Np/selfie/liveness.webm", required=true, value="Temporary URL for downloading a video selfie capture.")
    public String getVideoUrl() {
        return this.videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelfieCapture selfieCapture = (SelfieCapture)o;
        return Objects.equals(this.imageUrl, selfieCapture.imageUrl) && Objects.equals(this.videoUrl, selfieCapture.videoUrl);
    }

    public int hashCode() {
        return Objects.hash(this.imageUrl, this.videoUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SelfieCapture {\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        sb.append("    videoUrl: ").append(this.toIndentedString(this.videoUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

